local DEFAULT_BG_COLOR = "fc05e344"
local DEFAULT_FG_COLOR = "fc059dd0"
local DEFAULT_HL_COLOR = "fc059db0"
function sparktech.makebar(texture, posx, posy,
		sizex, sizey, value, maxvalue, direction)
	-- Direction means where to cap the texture at,
	-- default 0 is from the right, 2 is from the left
	-- 1 is from below and 3 is from above
	if direction == nil then direction = 0 end --direction is optional this way
	-- format : image[X,Y;W,H;texture_name]

	local ratio = value / maxvalue

	if direction == 0 then
		sizex = ratio * sizex
	elseif direction == 1 then
		sizey = ratio * sizey
	elseif direction == 2 then
		posx = posx + (sizex - (ratio * sizex))
		sizex = ratio * sizex
	elseif direction == 3 then
		posy = posy + (sizey - (ratio * sizey))
		sizey = ratio * sizey
	end

	return "image[" .. posx .. "," .. posy .. ";"
		.. sizex .. "," .. sizey .. ";" .. texture .. "]"
end


function verify_hexcolor_or_nil(s)
	if not s or #s ~= 8 or s:find("[^abcdefABCDEF0123456789]") then
		return nil
	end
	return s
end


function sparktech.add_inventory(size_x, size_y, formspec, scrollbarProgress, scrollbarHeight)
	if not scrollbarProgress then scrollbarProgress = 0 end
	if not scrollbarHeight then scrollbarHeight = 500 end
	-- pass an unfinished formspec with minimum size,
	-- this function adds an inventory
	local bg_color = verify_hexcolor_or_nil(
		minetest.settings:get("spark_gui_background")) or DEFAULT_BG_COLOR
	local fg_color = verify_hexcolor_or_nil(
		minetest.settings:get("spark_gui_foreground")) or DEFAULT_FG_COLOR
	local fg_highlight = verify_hexcolor_or_nil(
		minetest.settings:get("spark_gui_highlight")) or DEFAULT_HL_COLOR
	local gui_immersive  = minetest.settings:get("spark_gui_full") or "true"
	if not size_x or size_x < 20.5 then size_x = 20.5 end
	if not size_y or size_y < 0 then size_y = 0 end
	local offset = ( size_x - 16.5 ) / 2
	if offset < 0 then offset = 0 end
	-- FIXMT: The scrollbaroptions stepsize is incomprehensible
	-- what do these options even mean they seem to have no relation to the inventory sizes whatsoever
	-- and configuring the scrollbar to scroll exactly one inventory piece per scroll event seems to be impossible.
	local l_formspec =
		"size[" .. tostring(size_x) .. "," .. (size_y + 7.3) .. "]" ..
		"real_coordinates[true]" ..
		"list[current_player;main;" ..offset .."," .. size_y .. ";10,5;10]" ..
		"list[current_player;main;" ..offset .. "," .. (size_y + 6.25 ) .. ";10,1;]"..
		"scroll_container[" .. (13 + offset) .. "," .. size_y .. ";5,7.25;craftingScroller;vertical;0.1]" ..
		"list[current_player;crafting;0,0;4,500]" ..
		"scroll_container_end[]" ..
		"scrollbaroptions[min=0;max=".. scrollbarHeight .. ";smallstep=3]" ..
		"scrollbar["..(18 + offset)..",".. size_y.. ";.5,7.25;vertical;craftingScroller;" .. scrollbarProgress .."]" ..
		"listcolors[#" .. fg_color .. ";#" .. fg_highlight .. "]" ..
		"bgcolor[#" .. bg_color .. ";" .. gui_immersive .. "]"
	if not formspec then formspec = "" end
	l_formspec = l_formspec .. formspec
	return l_formspec
end

