local FUEL_MULTIPLIER = 2
local INTERVAL= 0.5
local MAX_ENERGY = 2000


local NAME = minetest.get_current_modname()

local formspec = sparktech.add_inventory(8,1.5,
  "list[current_name;fuel;0,0;1,1;]")


local function is_fuel(items)
	local fuel
	local afterfuel
	fuel, afterfuel = minetest.get_craft_result({method = "fuel", width = 1, items = items})
	return fuel["time"] ~= 0
end


local function is_item_allowed(pos, target, _, stack)
	if stack == nil or not is_fuel({stack}) or target ~= "fuel" or not sparktech.getoption(pos, "accept_items") then
		return 0 -- returning nil here crashes minetest 1942660955bc3684a60d527e2fafa0ec3e02dd54
	else				-- now it gives a lua error, neat :D
		return stack:get_count()
	end
end


local function ongetitem(pos) -- could add checking if energy >= max energy here, not really required since timer does that first thing anyway
	local timer = minetest.get_node_timer(pos):start(INTERVAL)
end


local function update_formspec(pos)
	local meta = minetest.get_meta(pos)
	local inventory = meta:get_inventory()
	local cfmsp = formspec

	local energy = meta:get_int("energy")
	local energy_max = minetest.get_item_group(minetest.get_node(pos).name, "sparktech_energy_max")

	local rem_en = meta:get_int("rem_energy_")
	local rem_en_or = meta:get_int("rem_energy_or_")

	cfmsp = cfmsp ..
		sparktech.makebar("progress2.png", 1.25, 0, 8.5, 0.5, rem_en, rem_en_or, 0)

	cfmsp = cfmsp ..
		sparktech.makebar("energy2.png", 1.25, 0.5, 8.5, 0.5, energy, energy_max, 0)

	meta:set_string("formspec", cfmsp)
end


minetest.register_node(NAME .. ":burnergenerator", {
	description = "Burner Generator",
	tiles = {    
		"generator2.png",
		"generator2.png",
		"generator2.png",
		"generator2.png",
		"generator2.png",
		"generator.png"},
	paramtype2 = "facedir",
	groups = {
		sparktech_techy = WRENCHABLE,
		sparktech_energy_wakeup = TRUE,
		sparktech_energy_type = ENERGY_PRODUCER,
		sparktech_net_trigger = TRUE,
		sparktech_energy_max = MAX_ENERGY
	},
	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		meta:set_string("formspec", formspec)
		meta:set_int("rem_energy_", 0)
		local inv = meta:get_inventory()
		inv:set_size('fuel', 1)
	--	minetest.get_node_timer(pos):start(INTERVAL)
	--	not required! its not like we got items on construct
	end,

	allow_metadata_inventory_put = is_item_allowed,

	on_metadata_inventory_put = ongetitem,

	on_timer = function(pos, elapsed) -- Reduce number of ticks like in the furnace
		local meta = minetest.get_meta(pos)
		local max_energy = minetest.get_item_group(minetest.get_node(pos).name, "sparktech_energy_max")
		local energy = meta:get_int("energy")
		if (energy >= max_energy) then
			return 	-- at this point no new cycle is requested, and as such the thing halts,
				-- NOTE: would be really usefull to get the energy system to call the
				-- ontimer function upon taking energy out here!!
		end

		local rem_energy = meta:get_int("rem_energy_")	

		if rem_energy > 0 then
			local change
			if rem_energy > 5 then
				change = 5
			else
				change = rem_energy
			end
			meta:set_int("rem_energy_", meta:get_int("rem_energy_") - change)
			if (energy + change >= max_energy) then
				meta:set_int("energy", max_energy)
			else
				meta:set_int("energy", energy + change)
			end
		else
			local inv = meta:get_inventory()
			local itemlist = inv:get_list("fuel")
			local fuel, product = minetest.get_craft_result({method = "fuel", width = 1, items = itemlist})
			local node = minetest.get_node(pos)
			if fuel["time"] ~= 0 then
				inv:set_stack("fuel", 1, product["items"][1])

				local fuel_energy = fuel["time"] * FUEL_MULTIPLIER
				meta:set_int("rem_energy_or_", fuel_energy)
				meta:set_int("rem_energy_", fuel_energy)
			end
		end

		update_formspec(pos) -- Later this should only be done when a player looks into the block

		minetest.get_node_timer(pos):start(INTERVAL)
	end,
	_sparkoptionchanged = function(pos, name)
		if name == "enabled" then
			local timer = minetest.get_node_timer(pos)
			if sparktech.getoption(pos, name) then
				timer:start(INTERVAL)
			else
				timer:stop()
			end
		end
	end,
	_sparkoption = {
		enabled = true,
		accept_items = true
	},
	_sparkoutput = {
		burntime = function(nodepos)
			local meta = minetest.get_meta(nodepos)
			local inventory = meta:get_inventory()
			local item = inventory:get_stack("fuel", 1)
			return item:get_meta():get_int("rem_energy_")
		end,
		item = function(nodepos)
			local meta = minetest.get_meta(nodepos)
			local inventory = meta:get_inventory()
			return inventory:get_stack("fuel", 1)
		end
	},
	_sparkoutputtype = {
		burntime = type(int),
		item = type(ItemStack())
	}
})


minetest.register_craft({
	output = NAME .. ":burnergenerator",
	recipe = {
		{ "orioncraft:copper_bar", "orioncraft:tin_bar", "orioncraft:copper_bar" },
		{ "sparkcore:cable",       "sparkcore:cable", "sparkcore:cable" },
		{ "orioncraft:iron_bar",   "orioncraft:iron_bar", "orioncraft:iron_bar" }
	}
})
