NAME = minetest:get_current_modname()
WORLD = "orionworld"


local box = {
	type = "fixed",
	fixed = {
		{-0.4, -0.5, -0.4, .4, .5, .4},
	},
}


minetest.register_node(NAME .. ":berry_bush", {
	description = "berry_bush",
	tiles = { NAME .. "_berry_bush.png" },
	groups = { flora = 2 },
	drawtype = "mesh",
	paramtype = "light",
	sunlight_propagates = true,
	inventory_image = NAME .. "_" .. "berry_bush.png",
	mesh = "berry_bush.obj",
	collision_box = box,
	selection_box = box,
})


minetest.register_decoration({
	deco_type = "simple",
	place_on = "orionworld:grass",
	decoration = NAME .. ":berry_bush",
	name = NAME .. ":berry_bush",
	noise_params = {
		offset = 0,
		scale = 0.0002,
		spread = {x = 2, y = 5, z = 2},
		seed = 354,
		octaves = 3,
		persistence = 0.6,
		lacunarity = 2.0,
		flags = "absvalue"
	},
	height = 1
})



orion.craft.register_fuel(NAME .. ":berry_bush", 7, 2)

minetest.register_craft({
        output = NAME .. ":stick", -- FIXME: Should give damn BERRIES as output! why is this not possible?
        type = "shapeless",
        recipe = {
                NAME .. ":berry_bush"
        },
})
