local NAME = minetest.get_current_modname()
local MAX_ENERGY = 200
local MAX_WEAR = 65535

local formspec = sparktech.add_inventory(8,1.5,
	"list[current_name;charge;0,0;1,1;]")

local SPEED = 10

minetest.register_node(NAME ..":charger", {
	description = "Electric Charger",
	tiles = {
		NAME .. "_steel_sideplate.png",
		NAME .. "_steel_sideplate.png",
		NAME .. "_steel_sideplate.png",
		NAME .. "_steel_sideplate.png",
		NAME .. "_steel_backplate.png",
		NAME .. "_charger_frontplate.png",
	},
	paramtype2 = "facedir",
	groups = {
		sparktech_techy = WRENCHABLE,
		sparktech_energy_type = ENERGY_CONSUMER,
		sparktech_energy_storeonbreak = TRUE,
		sparktech_net_trigger = TRUE,
		sparktech_energy_max = MAX_ENERGY,
		sparktech_energy_wakeup = 10,
		sparktech_io = TRUE
	},
	on_metadata_inventory_take = function(pos)
		local meta = minetest.get_meta(pos)
		meta:set_string("formspec", formspec ..
			sparktech.makebar("energy2.png",
			1.25, 0.0, 8, 1, meta:get_int("energy"),
			minetest.get_item_group(
				minetest.get_node(pos).name,
				"sparktech_energy_max"),
			0)
		)
		return 1
	end,
	allow_metadata_inventory_put = function (pos, listname, index, itemstack, player)
		if listname ~= "charge" then return 0 end
		if index == nil then index = 1 end
		if index ~= 1 then return 0 end

		local inventory = minetest.get_inventory({type="node", pos=pos})

		if inventory:room_for_item(listname, itemstack) and
		minetest.get_item_group(itemstack:get_name(), "sparktech_chargeable") > 0 then
			return 1
		else
			return 0
		end
	end,
	allow_metadata_inventory_take = function(pos, listname, index, _--[[ Already have the listname AND index]], player)
		if listname ~= "charge" then return 0 end
		if index == nil then index = 1 end
		if index ~= 1 then return 0 end
		local inventory = minetest.get_inventory({type="node", pos=pos})
		local item = inventory:get_stack(listname, index)

		if item:get_name() ~= "" then
			return item:get_count()
		else
			return 0
		end
	end,
	on_metadata_inventory_put = function (pos)
		local meta = minetest.get_meta(pos)
		if meta:get_int("energy") <= 0 or not sparktech.getoption(pos, "enabled") then return end
		local timer = minetest.get_node_timer(pos)
		timer:start(1.0)
	end,
	on_timer = function (pos, elapsed)
		if not sparktech.getoption(pos, "enabled") then return end
		local node_meta = minetest.get_meta(pos)
		local node_energy = node_meta:get_int("energy")
		local node_inventory = node_meta:get_inventory()

		local item = node_inventory:get_stack("charge", 1)
		local item_meta = item:get_meta()
		local item_charge_old = item_meta:get_int("energy") -- curr
		local item_charge_max = minetest.get_item_group(item:get_name(), "sparktech_chargable") / minetest.registered_nodes[NAME .. ":charger"]._sparkoption.max_chargeratio
		local item_charge_diff = math.min(item_charge_max - item_charge_old, SPEED)
		local item_charge_new = item_charge_old + item_charge_diff

		if node_energy >= item_charge_diff then
			item_meta:set_int("energy", item_charge_new)
			node_energy = node_energy - item_charge_diff
			node_meta:set_int("energy", node_energy)

			local item_wear = (item_charge_new / item_charge_max) * MAX_WEAR
			item:set_wear(1 + MAX_WEAR - math.ceil(item_wear))

			local item_caps_charge = item:get_definition().spark_caps_charge
			item_meta:set_tool_capabilities(item_caps_charge)

			node_inventory:set_stack("charge", 1, item)
		end

		local fin_formspec = ""

		if item_charge_diff ~= 0 then
			local timer = minetest.get_node_timer(pos)
			timer:start(1.0)
		else
			fin_formspec = "image[0,0;1,1;" .. NAME .. "_fin.png]"
		end

		node_meta:set_string("formspec", formspec .. fin_formspec ..
			sparktech.makebar("energy2.png",
				1.25, 0.0, 8, 1, node_energy,
				minetest.get_item_group(
					minetest.get_node(pos).name,
					"sparktech_energy_max"),
				0
			)
		)
	end,
	on_construct = function(pos, placer)
		local meta = minetest.get_meta(pos)
		meta:set_string("formspec", formspec)
		local inventory = meta:get_inventory()
		inventory:set_size('charge', 1)
	end,
	_sparkoptionchanged = function(pos, name)
		if name == "enabled" then
			local timer = minetest.get_node_timer(pos)
			if sparktech.getoption(pos, name) then
				timer:start(1.0)
			else
				timer:stop()
			end
		end
	end,
	_sparkoption = {
		enabled = true,
		max_chargeratio = 1
	},
	_sparkoutput = {
		charge = function(nodepos)
			local meta = minetest.get_meta(nodepos)
			local inventory = meta:get_inventory()
			local item = inventory:get_stack("charge", 1)
			local charge = item:get_meta():get_int("energy")
			if charge == 0 then return 0 end
			return charge / minetest.get_item_group(item:get_name(), "sparktech_chargable")
		end,
		item = function(nodepos)
			local meta = minetest.get_meta(nodepos)
			local inventory = meta:get_inventory()
			return inventory:get_stack("charge", 1)
		end
	},
	_sparkoutputtype = {
		charge = type(1),
		item = "ItemStack"
	}
})

minetest.register_craft({
	output = NAME .. ":charger",
		recipe = {
			{ "orioncraft:iron_bar",  "",               "orioncraft:iron_bar" },
			{ "sparkcore:cable",     "sparkcore:cable", "sparkcore:cable" },
			{ "orioncraft:gold_bar", "",                "orioncraft:gold_bar" },
		}
})
