-- dofile(core.get_modpath(core.get_current_modname()) .. "/testing-2.lua")


print("mineral mod init");

-- register the hand tool
core.register_tool(":", {
	description = "hand",
	wield_image = "tool_hand.png",
	tool_capabilities = {
		groupcaps = {
			oddly_breakable_by_hand = {maxlevel = 5, uses = 20, times = {[1] = 1.60, [2] = 1.20, [3] = 0.80}},
			crumbly = {maxlevel = 3, uses = 20, times = {[1] = 1.60, [2] = 1.20, [3] = 0.80}},
		}
	},
})

core.register_node("mineral:sand", {
	description = "ordinary sand",
	tiles = {{name = "mineral_sand.png"}},
	groups = {crumbly = 3, cracky = 3, oddly_breakable_by_hand = 2},
})

core.register_node("mineral:stone", {
	description = "stone (regolith)",
	tiles = {{name = "mineral_stone.png"}},
	groups = {cracky = 2, oddly_breakable_by_hand = 1},
--	drawtype = "airlike",
})

core.register_alias("mapgen_stone", "mineral:stone");
core.register_alias("mapgen_water_source", "mineral:sand");
core.register_alias("mapgen_river_water_source", "air");
core.register_alias("mapgen_lava_source", "mineral:sand");
core.register_alias("mapgen_dirt", "mineral:stone");
core.register_alias("mapgen_dirt_with_grass", "mineral:sand");
core.register_alias("mapgen_sand", "mineral:stone");
core.register_alias("mapgen_tree", "air");
core.register_alias("mapgen_leaves", "air");
core.register_alias("mapgen_apple", "air");
core.register_alias("mapgen_cobble", "air");

core.register_alias("mapgen_singlenode", "mineral:stone");

core.register_node("mineral:ice_low", {
	description = "mineral with 20% water ice content",
	tiles = {{name = "mineral_ice_low.png"}},
	groups = {cracky = 2, oddly_breakable_by_hand = 1, smeltable = 1},
	smelt = "mineral:stone",
	wetness = 0.2001,
})

core.register_node("mineral:ice_medium", {
	description = "mineral with 50% water ice content",
	tiles = {{name = "mineral_ice_medium.png"}},
	groups = {cracky = 2, oddly_breakable_by_hand = 1, smeltable = 1},
	smelt = "mineral:stone",
	wetness = 0.5001
})

core.register_node("mineral:ice_high", {
	description = "mineral with 80% water ice content",
	tiles = {{name = "mineral_ice_high.png"}},
	groups = {cracky = 2, oddly_breakable_by_hand = 1, smeltable = 1},
	smelt = "mineral:sand",
	wetness = 0.8001
})

core.register_node("mineral:ice", {
	description = "pure water ice",
	tiles = {{name = "mineral_ice_pure.png"}},
	groups = {cracky = 2, oddly_breakable_by_hand = 1, smeltable = 1},
	smelt = nil,
	wetness = 1.001,
})

--core.register_biome({
--	name = "hot_dry",
--	node_top = "mineral:stone",
--	depth_top = 2,
--	node_filler = "mineral:stone",
--	depth_filler = 3,
--	node_riverbed = "mineral:stone",
--	depth_riverbed = 3,
--	heat_point = 30,
--	humidity_point = 20,
--})
--
--core.register_biome({
--	name = "hot_mod",
--	node_top = "mineral:stone",
--	depth_top = 2,
--	node_filler = "mineral:stone",
--	depth_filler = 3,
--	node_riverbed = "mineral:stone",
--	depth_riverbed = 3,
--	heat_point = 30,
--	humidity_point = 60,
--})
--
--core.register_biome({
--	name = "hot_wet",
--	node_top = "mineral:stone",
--	depth_top = 2,
--	node_filler = "mineral:stone",
--	depth_filler = 3,
--	node_riverbed = "mineral:stone",
--	depth_riverbed = 3,
--	heat_point = 30,
--	humidity_point = 100,
--})
--
--core.register_biome({
--	name = "cold_dry",
--	node_top = "mineral:ice_low",
--	depth_top = 1,
--	node_filler = "mineral:ice_low",
--	depth_filler = 1,
--	node_riverbed = "mineral:ice_low",
--	depth_riverbed = 1,
--	heat_point = 10,
--	humidity_point = 20,
--})
--
--core.register_biome({
--	name = "cold_mod",
--	node_top = "mineral:ice_medium",
--	depth_top = 2,
--	node_filler = "mineral:ice_medium",
--	depth_filler = 2,
--	node_riverbed = "mineral:ice_medium",
--	depth_riverbed = 2,
--	heat_point = 10,
--	humidity_point = 60,
--})
--
--core.register_biome({
--	name = "cold_wet",
--	node_top = "mineral:ice",
--	depth_top = 2,
--	node_filler = "mineral:ice_medium",
--	depth_filler = 3,
--	node_riverbed = "mineral:ice",
--	depth_riverbed = 3,
--	heat_point = 10,
--	humidity_point = 100,
--	z_min = 1000,
--	z_max = 2000,
--})

core.register_biome({
	name = "equator",
	node_top = "mineral:stone",
	depth_top = 2,
	node_filler = "mineral:stone",
	depth_filler = 3,
	node_riverbed = "mineral:stone",
	depth_riverbed = 3,
	heat_point = 120, -- intentionally far-out value to make cold preferable
	humidity_point = 50,
})

core.register_biome({
	name = "north_50",
	node_top = "mineral:ice_low",
	depth_top = 1,
	node_filler = "mineral:ice_low",
	depth_filler = 1,
	node_riverbed = "mineral:ice_low",
	depth_riverbed = 1,
	heat_point = 90,
	humidity_point = 50,
	-- according to this article:
	-- https://gist.github.com/chris-roerig/5a786bb8292a6d13d01753446ad0790a
	min_pos = { z = 2500 },
	max_pos = { },
})

core.register_biome({
	name = "north_55",
	node_top = "mineral:ice_medium",
	depth_top = 2,
	node_filler = "mineral:ice_medium",
	depth_filler = 3,
	node_riverbed = "mineral:ice_medium",
	depth_riverbed = 3,
	heat_point = 70,
	humidity_point = 50,
	-- according to this article:
	-- https://gist.github.com/chris-roerig/5a786bb8292a6d13d01753446ad0790a
	min_pos = { z = 2750 },
	max_pos = { },
})


core.register_biome({
	name = "north_60", -- 60 degrees latitude, 4500 km from equator irl, 3000 nodes from equator ingame
	node_top = "mineral:ice",
	depth_top = 2,
	node_filler = "mineral:ice_medium",
	depth_filler = 3,
	node_riverbed = "mineral:ice",
	depth_riverbed = 3,
	heat_point = 50,
	humidity_point = 50,
	-- according to this article:
	-- https://gist.github.com/chris-roerig/5a786bb8292a6d13d01753446ad0790a
	min_pos = { z = 3000 },
	max_pos = { },
})


-- we want to make sure that the heat corresponds to solar irradiation
-- and thus to perceived landscape brightness


local daylight_update_trigger = 0

-- globally available function
get_latitude_light = function (pos)
	-- visual brightness only depends on z value (latitude)
	-- first, calculate latitude (in radians) from z value
	-- actually, 60° latitude would be z = 3000
	-- but to make the game more interesting, we pretend that z = 3000 means a latitude of 90° north
--	local lat = pos.z / 50 -- in degrees
	local lat = pos.z / 33.3 -- in degrees
	lat = lat / 360 * 2 * math.pi -- in radians
	local light = math.cos(lat)
	if light < 0 then light = 0 end
	return light
end

core.register_globalstep(function (dtime)
	daylight_update_trigger = daylight_update_trigger + dtime
	if daylight_update_trigger < 1 then return end
	daylight_update_trigger = daylight_update_trigger - 1

	local timeofday = core.get_timeofday()
	-- core.chat_send_all("timeofday: " .. timeofday)
	local ratio = core.time_to_day_night_ratio(timeofday)
	-- core.chat_send_all("ratio: " .. ratio)
	local players = core.get_connected_players()
	for _, player in ipairs(players) do
		local heat = get_latitude_light(player:get_pos())
		heat = heat + 0.1 -- atmospheric refraction
		if heat < 0 then heat = 0 end
		if heat > 1 then heat = 1 end
		-- print(heat)
		-- assume that heat is solar irradiation
		-- as a fraction of the maximum value.
		-- so we multiply the default brightness with the heat value.
		local player_ratio = ratio * heat
		player:override_day_night_ratio(player_ratio)
	end
end)



local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)

dofile(modpath .. "/chat-commands.lua")
dofile(modpath .. "/ores.lua")

