-- this code discusses an electrolysis machine

function get_elysis_formspec (elysis_progress)
	local progstr = ""
	if elysis_progress ~= nil and elysis_progress > 0 then
		elysis_progress = math.floor(elysis_progress * 100)
		progstr = "label[1,4;Electrolysis progress: " .. elysis_progress .. "%]"
	end
	local text = "" ..
		"formspec_version[4]" ..
		"size[10.75,10.5]" ..
		-- first some top text
		"label[1,0.75;Electrolysis of water]" ..
		-- input slot
		"list[context;water;2.5,2.1;1,1;]" ..
		-- text info: electrolysis progress
		progstr ..
		-- oxygen output slot
		"list[context;oxygen;7,2.1;1,1;]" ..
		-- secondary output slot (for hydrogen)
		"list[context;hydrogen;7,3.5;1,1;]" ..
		-- player inventory starts at y = 4.75, then 0.5 padding (?)
		"list[current_player;main;0.5,5.25;8,4;]" -- 0.5 padding on each side
	return text
end

local on_timer_elysis = function (pos)
	on_timer_cable(pos)

	-- we store an internal variable in the elysis machine
	-- that indicates progress
	-- in case an item is currently in the water inventory slot.

	local meta = core.get_meta(pos)
	local inv = core.get_inventory({type = "node", pos = pos})
	local src_stack = inv:get_stack("water", 1)
	local src_name = src_stack:get_name()
	local smeltable = (src_name == "ess:water")
	local progress = meta:get_float("progress")

	print("src_stack", src_stack)
	if src_stack:is_empty() then
		-- src is empty, abort progress
		meta:set_float("progress", 0.0)

	elseif smeltable and meta:get_float("charge") > 0 then

		local charge = meta:get_float("charge")
		local expenses = math.min((1.001 - progress) * 3.6e6, charge)
		charge = charge - expenses
		meta:set_float("charge", charge)
		progress = progress + expenses / 3.6e6
		meta:set_float("progress", progress)

		if progress >= 1 then
			-- take one item off the source stack
			src_stack:set_count(src_stack:get_count() - 1)
			inv:set_stack("water", 1, src_stack)
			-- add one to each output stack
			local result_stack = ItemStack({name = "ess:oxygen", count = 1})
			local dest_stack = inv:get_stack("oxygen", 1)
			result_stack = dest_stack:add_item(result_stack)
			inv:set_stack("oxygen", 1, dest_stack)
			print("added results, leftovers:", result_stack)
			-- and subtract 1 from the progress
			meta:set_float("progress", progress - 1)

			-- todo: also output hydrogen
		end
	end

	meta:set_string("formspec", get_elysis_formspec(progress))

	return true
end

core.register_node("energy:elysis", {
	description = "electrolysis machine",
	tiles = {
		"energy_elysis_side.png",
		"energy_elysis_side.png",
		"energy_elysis_side.png",
		"energy_elysis_side.png",
		"energy_elysis_side.png",
		"energy_elysis_side.png",
	},
	is_ground_content = false,
	groups = {cable = 1, oddly_breakable_by_hand = 1},
	drop = "energy:elysis",

	on_construct = function (pos)
		-- define the inventory space for the node
		local meta = core.get_meta(pos)
		local inv = meta:get_inventory()
		inv:set_size("water", 1) -- water slot
		inv:set_size("oxygen", 1) -- oxygen slot
		inv:set_size("hydrogen", 1) -- hydrogen slot
		-- define the formspec text (is displayed automatically on right-click)
		meta:set_string("formspec", get_elysis_formspec(nil))
	end,
	on_timer = on_timer_elysis,

})



