-- this is to initialize the player's inventory when the player first spawns

-- make a new test world to test this behavior

-- since default luanti behavior is to keep the inventory (which should probably be changed later, like in the gravestone mod),
-- we're gonna give the player free stuff *when they join the world for the first time*
-- this means, instead of core.register_on_respawnplayer,
-- we're gonna use core.register_on_joinplayer
-- and check whether last_login == nil

core.register_on_joinplayer(function (player, last_login)
	print("player joined, last_login", last_login)
	if last_login ~= nil then
		return
	end

	-- player joins for the first time
	-- give them free stuff
	local inv = player:get_inventory()
	print("got inventory", inv)
	inv:set_stack("main", 1,  ItemStack("heres_energy:solar 60"))
	inv:set_stack("main", 2,  ItemStack("heres_energy:cable 60"))
	inv:set_stack("main", 3,  ItemStack("heres_energy:torch 10"))
	inv:set_stack("main", 4,  ItemStack("heres_energy:furnace 2"))
	inv:set_stack("main", 5,  ItemStack("heres_energy:elysis 2"))
end)

