print("energy mod init");

-- define the timer interval and start the timer when group:cable nodes are placed down

local timer_interval = 0.5

-- we're gonna use a node timer to make the group:cable nodes
-- transport electricity. every group:cable node holds metadata
-- i.e. core.get_meta(pos):get_float("charge")
-- this timer begins running when the node is placed down

core.register_on_placenode(function (pos, newnode, placer, oldnode, itemstack, pointed_thing)
	-- check whether the placed node is a part of the group:cable group
	local rating = core.get_item_group(newnode.name, "cable")
	if rating ~= 0 then
		print("installing timer on node pos", pos)
		local timer = core.get_node_timer(pos)
		timer:start(timer_interval)
	end
end)



-- we have to define the handler functions for the node timers
-- local on_timer_cable = function (pos)
-- it needs to be global because we're gonna access it in furnace.lua
on_timer_cable = function (pos)
--	print("timer called on pos", pos)
	local pos1 = vector.add(pos, -1)
	local pos2 = vector.add(pos,  1)
	local list = core.find_nodes_in_area(pos1, pos2, "group:cable", false)
--	print("found:", core.write_json(list))
	-- now, to sum the "charge" meta variable.
	local sum = 0
	local count = 0
	for _, v in ipairs(list) do
		sum = sum + core.get_meta(v):get_float("charge")
		count = count + 1
	end
--	print("count", count, "sum", sum, "charge", core.get_meta(pos):get_float("charge"))
	-- now redistribute it
	local average_charge = sum / count
	for _, v in ipairs(list) do
		core.get_meta(v):set_float("charge", average_charge)
	end
	return true
end

local on_timer_solar = function (pos)
	on_timer_cable(pos)

	-- we know how much time passed since last timer invocation,
	-- which is timer_interval
	-- this is only true as long as the node is in a loaded block,
	-- but that's an assumption we can make. inactive blocks don't tick,
	-- that's well-known enough to be able to assume it.

	local dtime = timer_interval
	local charge = core.get_meta(pos):get_float("charge")
--	local heat = core.get_heat(pos) / 100 -- represents latitude
	local heat = get_latitude_light(pos) -- represents latitude
	if heat < 0 then heat = 0 end
	if heat > 1 then heat = 1 end
	local max_power = 6000 -- 100 J/s * 60 s/min
	local timeofday = core.get_timeofday() -- represents time of day
	-- daylight_factor : respects time-of-day
	local daylight_factor = math.cos((timeofday - 0.5) * 2 * math.pi)
	if daylight_factor < 0 then daylight_factor = 0 end
	-- natural_light : caves get lower values
	local natural_light = core.get_natural_light(pos) / 15
	charge = charge + max_power * dtime * daylight_factor * heat * natural_light
	if charge > 500000 then charge = 500000 end -- a cable can hold max 0.5 MJ
	core.get_meta(pos):set_float("charge", charge)

	return true
end

local on_timer_torch = function (pos)
	on_timer_cable(pos)

	-- assume that power consumption grows with the 4th power
	-- of emitted light level.
	-- if the torch is completely lit, it emits as much power
	-- as one solar panel produces (100 W irl, 6000 J/ingame s).

	local charge = core.get_meta(pos):get_float("charge")
	local light_level = math.floor(15.0 * math.sqrt(math.sqrt(charge / 6000)))
	if light_level > 15 then light_level = 15 end
	if light_level <  0 then light_level = 0 end
	local dtime = timer_interval
	charge = charge - ((light_level / 15.0) ^ 4) * 6000 * dtime
	core.get_meta(pos):set_float("charge", charge)

--	local node = core.get_node(pos)
--	local param1 = node.param1 + 16*light_level
--	print("on_timer_torch")
--	print("pos", pos)
--	print("light_level", light_level)
--	print("param1", param1)
--	print(core.set_node_light)

	-- setting node.param1 manually doesn't work
	-- instead, we have to set a new node with a .light_source defined.
	core.swap_node(pos, {name = "heres_energy:torch" .. light_level })

	return true
end



-- node definitions; we have to define the cables

local tex_cable = "energy_cable"

core.register_node("heres_energy:cable", {
	description = "Cable",
	drawtype = "raillike",
	paramtype = "light",
	is_ground_content = false,
	walkable = false,
	sunlight_propagates = true,
	tiles = {tex_cable .. ".1.png", tex_cable .. ".2.png", tex_cable .. ".3.png", tex_cable .. ".4.png"},
	groups = {cable = 1, dig_immediate = 3, snappy = 3, attached_node = 3},
	-- group attached_node = 3 ... node is always attached to node below
	-- groups = {handy=1,pickaxey=1, attached_node=1,rail=1,connect_to_raillike=core.raillike_group("rail"),transport=1, no_spawning_inside=1},
	connects_to = {"group:cable"},	
	selection_box = {
		type = "fixed",
		fixed = {-1/2, -1/2, -1/2, 1/2, -1/2+1/16, 1/2},
	},
	on_timer = on_timer_cable,
})

local tex_solar = "energy_solar.png"

core.register_node("heres_energy:solar", {
	description = "solar panel",
	drawtype = "raillike",
	paramtype = "light",
	is_ground_content = false,
	walkable = false,
	sunlight_propagates = false,
	tiles = {tex_solar, tex_solar, tex_solar, tex_solar},
	groups = {cable = 1, dig_immediate = 3, attached_node = 3},
	selection_box = {
		type = "fixed",
		fixed = {-1/2, -1/2, -1/2, 1/2, -1/2+1/16, 1/2},
	},
	on_timer = on_timer_solar,
})

local tex_torch_up = "energy_torch.1.png"
local tex_torch_down = "energy_torch.2.png"
local tex_torch_side = "energy_torch.3.png"

local torch_def = {
	description = "electrically powered torch",
	drawtype = "nodebox",
	-- the "nodebox" drawing type isn't perfect because
	-- it doesn't connect (visually) to raillike drawing type.
	-- ideally, all group:cable nodes would be entities.
	paramtype = "light",
	drop = "heres_energy:torch",
	is_ground_content = false,
	walkable = false,
	sunlight_propagates = true,
	tiles = {tex_torch_up, tex_torch_down, tex_torch_side},
	groups = {cable = 1, dig_immediate = 3, attached_node = 3},
	node_box = {
		type = "connected",
		fixed = { -1/16, -1/2, -1/16, 1/16, 4/16, 1/16 },
--		connect_front = { -1/16, -1/2+1/64, -1, 1/16, -1/2+1/64, 0 },
	},
	connects_to = {"group:cable"},
	on_timer = on_timer_torch,
}

-- this is the node used for items in inventories
core.register_node("heres_energy:torch", torch_def)

-- register one additional node for each light level
for light_level = 0, 15 do

	local torch_def_light_source = table.copy(torch_def)
	torch_def_light_source.light_source = light_level
	-- due to a weird bug(?) you cannot register nodes with a
	-- light_source level of 15

	if light_level > core.LIGHT_MAX then
		torch_def_light_source.light_source = core.LIGHT_MAX
	end
	core.register_node("heres_energy:torch" .. light_level, torch_def_light_source)
end


local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)

dofile(modpath .. "/furnace.lua")
dofile(modpath .. "/electrolysis.lua")
dofile(modpath .. "/chat-commands.lua")
