
function get_furnace_formspec (smelting_progress)
	local smeltstr = ""
	if smelting_progress ~= nil and smelting_progress > 0 then
		smelting_progress = math.floor(smelting_progress * 100)
		smeltstr = "label[1,4;Smelting progress: " .. smelting_progress .. "%]"
	end
	local text = "" ..
		"formspec_version[4]" ..
		"size[10.75,10.5]" ..
		-- first some top text
		"label[1,0.75;Electrically powered Furnace]" ..
		-- input slot
		"list[context;src;2.5,2.1;1,1;]" ..
		-- text info: smelting progress
		smeltstr ..
		-- primary output slot
		"list[context;dest;7,2.1;1,1;]" ..
		-- output slot for water :D
		"list[context;water;7,3.5;1,1;]" ..
		-- player inventory starts at y = 4.75, then 0.5 padding
		"list[current_player;main;0.5,5.25;8,4;]" -- 0.5 padding on each side
	return text
end

local on_timer_furnace = function (pos)
	on_timer_cable(pos)

	-- we store an internal variable in the furnace
	-- that indicates smelting progress
	-- in case an item is currently in the src inventory slot.

	local meta = core.get_meta(pos)
	local inv = core.get_inventory({type = "node", pos = pos})
	local src_stack = inv:get_stack("src", 1)
	local src_name = src_stack:get_name()
	local smeltable = core.get_item_group(src_name, "smeltable")
	local smelting_progress = meta:get_float("smelting_progress")

	print("src_stack", src_stack)
	if src_stack:is_empty() then
		-- src is empty, abort smelting
		meta:set_float("smelting_progress", 0.0)
		-- replace this node by an inactive furnace
		core.swap_node(pos, {name = "hrs_machine:furnace"})

	elseif smeltable ~= 0 and meta:get_float("charge") > 0 then

		core.swap_node(pos, {name = "hrs_machine:furnace_active"})
		local charge = meta:get_float("charge")
		local expenses = math.min((1.001 - smelting_progress) * 3.6e6, charge)
		charge = charge - expenses
		meta:set_float("charge", charge)
		smelting_progress = smelting_progress + expenses / 3.6e6
		meta:set_float("smelting_progress", smelting_progress)

		if smelting_progress >= 1 then
			local def = core.registered_nodes[src_name]
			print("src def", def)
			local smelt = def.smelt
			print("smelt", smelt)
			local wetness = def.wetness
			print("wetness", wetness)
			-- take one item off the source stack,
			src_stack:set_count(src_stack:get_count() - 1)
			inv:set_stack("src", 1, src_stack)
			-- add one to the result stack
			local result_stack = ItemStack({name = smelt, count = 1})
			local dest_stack = inv:get_stack("dest", 1)
			result_stack = dest_stack:add_item(result_stack)
			inv:set_stack("dest", 1, dest_stack)
			print("added results, leftovers:", result_stack)
			-- and subtract 1 from the smelting_progress
			meta:set_float("smelting_progress", smelting_progress - 1)
			-- also store the added wetness internally
			local water = meta:get_float("water")
			water = water + wetness
			meta:set_float("water", water)
			-- also if water >= 1, add a bottle to the water output stack
			if water >= 1 then
				water = water - 1
				meta:set_float("water", water)
				local water_stack = inv:get_stack("water", 1)
				local bottle = ItemStack({name = "hrs_material:water", count = 1})
				water_stack:add_item(bottle)
				inv:set_stack("water", 1, water_stack)
			end
		end
	end

	meta:set_string("formspec", get_furnace_formspec(smelting_progress))

	return true
end

local furnace_def = {
	description = "electrically powered furnace",
	tiles = {
		"energy_furnace_side.png",
		"energy_furnace_side.png",
		"energy_furnace_side.png",
		"energy_furnace_side.png",
		"energy_furnace_side.png",
		"energy_furnace_front_still.png",
	},
	is_ground_content = false,
	groups = {cable = 1, oddly_breakable_by_hand = 1},
	drop = "hrs_machine:furnace",

	-- it is the goal here to show a simple HUD when the furnace is right-clicked
	-- turns out that luanti does that automatically when you right-click the furnace and the furnace does not have an explicitely defined on_rightclick handler and the formspec is stored in meta string "formspec"
--	on_rightclick = display_furnace_HUD,
	on_construct = function (pos)
		-- define the inventory space for the node
		local meta = core.get_meta(pos)
		local inv = meta:get_inventory()
		inv:set_size("src", 1) -- source slot
		inv:set_size("dest", 1) -- destination slot
		inv:set_size("water", 1) -- water output slot
		-- define the formspec text (is displayed automatically on right-click)
		meta:set_string("formspec", get_furnace_formspec(nil))
--		meta:set_string("infotext", "Electrically powered Furnace")
	end,
	on_timer = on_timer_furnace,
}

-- one variant for the inactive furnace
core.register_node("hrs_machine:furnace", furnace_def)
-- a second variant for the active (smelting) furnace
furnace_def = table.copy(furnace_def)
furnace_def.tiles[6] = "energy_furnace_front_active.png"
core.register_node("hrs_machine:furnace_active", furnace_def)


