-- this file defines the perceived daylight brightness for the user


-- we want to make sure that the heat corresponds to solar irradiation
-- and thus to perceived landscape brightness


local daylight_update_trigger = 0

-- globally available function
-- solar panels rely on this, too
get_latitude_light = function (pos)
	-- visual brightness only depends on z value (latitude)
	-- first, calculate latitude (in radians) from z value
	-- actually, 60° latitude would be z = 3000
	-- but to make the game more interesting, we pretend that z = 3000 means a latitude of 90° north
--	local lat = pos.z / 50 -- in degrees
	local lat = pos.z / 33.3 -- in degrees
	lat = lat / 360 * 2 * math.pi -- in radians
	local light = math.cos(lat)
	if light < 0 then light = 0 end
	return light
end

core.register_globalstep(function (dtime)
	daylight_update_trigger = daylight_update_trigger + dtime
	if daylight_update_trigger < 1 then return end
	daylight_update_trigger = daylight_update_trigger - 1

	local timeofday = core.get_timeofday()
	-- core.chat_send_all("timeofday: " .. timeofday)
	local ratio = core.time_to_day_night_ratio(timeofday)
	-- core.chat_send_all("ratio: " .. ratio)
	local players = core.get_connected_players()
	for _, player in ipairs(players) do
		local heat = get_latitude_light(player:get_pos())
		heat = heat + 0.1 -- atmospheric refraction
		if heat < 0 then heat = 0 end
		if heat > 1 then heat = 1 end
		-- print(heat)
		-- assume that heat is solar irradiation
		-- as a fraction of the maximum value.
		-- so we multiply the default brightness with the heat value.
		local player_ratio = ratio * heat
		player:override_day_night_ratio(player_ratio)
	end
end)

