
-- tell the user the name of the biome they're currently in
core.register_chatcommand("biome", {
	func = function (name, param)
		-- name is the player's name
		-- the player could be offline, so we check
		local player = core.get_player_by_name(name)
		if player == nil then
			return false, "player is offline!"
		end
		print("player pos", player:get_pos())
		print("heat at player pos", core.get_heat(player:get_pos()))
		local heat = core.get_heat(player:get_pos())
		local humidity = core.get_humidity(player:get_pos())
		print("humidity at player pos", humidity)
		return true, "heat is " .. heat .. ", humidity is " .. humidity
	end,
})

core.register_chatcommand("dark", {
	func = function (name, param)
		local timeofday = core.get_timeofday()
		print("timeofday", timeofday)
		local ratio = 0.2
		local player = core.get_player_by_name(name)
		player:override_day_night_ratio(ratio)
	end
})

core.register_chatcommand("light", {
	func = function (name, param)
		local timeofday = core.get_timeofday()
		print("timeofday", timeofday)
		local ratio = 1.0
		local player = core.get_player_by_name(name)
		player:override_day_night_ratio(ratio)
	end
})

core.register_chatcommand("auto", {
	func = function (name, param)
		local timeofday = core.get_timeofday()
		print("timeofday", timeofday)
		local ratio = nil
		local player = core.get_player_by_name(name)
		player:override_day_night_ratio(ratio)
	end
})
