-- LUALOCALS < ---------------------------------------------------------
local math, minetest, nodecore, pairs, string, vector
    = math, minetest, nodecore, pairs, string, vector
local math_ceil, math_log, string_gsub
    = math.ceil, math.log, string.gsub
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

minetest.register_node(modname..":form",{
	description = "Pumice Form",
	drawtype = "glasslike_framed",
	tiles = {"nc_heaterForm.png"},
	sounds = nodecore.sounds("nc_optics_glassy", nil, 0.82344178931),
	groups = {cracky=2}
})
nodecore.register_craft({
	label = "hollow pumice",
	action = "pummel",
	groups = {thumpy = 3},
	indexkeys = {"nc_lode:rod_tempered"},
	duration = 1,
	nodes = {
		{y = -1, match = "nc_igneous:pumice", replace = modname..":form"},
		{y = 0, match = "nc_lode:rod_tempered", replace = "nc_lode:rod_tempered"}
	}
})

nodecore.register_craft({
	label = "make heater",
	action = "pummel",
	groups = {thumpy = 3},
	indexkeys = {"nc_igneous:amalgam"},
	--no duration = instaneous
	nodes = {
		{y = -1, match = modname..":form", replace = modname..":heater_new"},
		{y = 0, match = "nc_igneous:amalgam", replace = "air"}
	}
})

minetest.register_node(modname..":heater_0",{
	description = "Heater",
	tiles = {"nc_heater_0.png"},
	sounds = nodecore.sounds("nc_optics_glassy", nil, 0.82344178931),
	groups = {cracky=2,heater=1}
})


minetest.register_node(modname..":heater_broken",{--Broken
	description = "Broken Heater",
	tiles = {"nc_heater_amalgam.png"},
	light_source=1,
	sounds = nodecore.sounds("nc_optics_glassy", nil, 0.82344178931),
	groups = {damage_touch=1,heater=1}
})
nodecore.register_craft({
	label = "Broken Heater Melting",
	action = "cook",
	touchgroups = {},
	neargroups = {},
	duration = 1,
	priority = 2,
	cookfx = {hiss=true,smoke=true},
	indexkeys = {modname..":heater_broken"},
	nodes = {
		{match = modname..":heater_broken", replace = "nc_igneous:amalgam"}
	}
})


minetest.register_node(modname..":heater_new",{--Forming
	description = "Heater",
	tiles = {"nc_heater_amalgam.png"},
	light_source=1,
	sounds = nodecore.sounds("nc_optics_glassy", nil, 0.82344178931),
	groups = {damage_touch=1,heater=1}
})
nodecore.register_craft({
	label = "Broken Heater Melting",
	action = "cook",
	touchgroups = {},
	neargroups = {},
	duration = 1,
	priority = 2,
	cookfx = false,
	indexkeys = {modname..":heater_new"},
	nodes = {
		{match = modname..":heater_new", replace = modname..":heater_0"}
	}
})




for i=1,6 do
	minetest.register_node(modname..":heater_"..tostring(i),{
		description = "Heater",
		light_source = i,
		tiles = {"nc_heater_"..tostring(i)..".png"},
		stack_max = 0,--wait until it's cool to the touch or you will burn your hand.
		sounds = nodecore.sounds("nc_optics_glassy", nil, 0.7),
		groups = {damage_touch=1, damage_radiant=math_ceil(i/2),heater=1}
		
	})
end

--Configure the crafting recipes...

for i=0,6 do

		nodecore.register_craft({
			label = "heater heating",
			action = "cook",
			touchgroups = {optic_lens_emit = 1},
			neargroups = {coolant=0},
			duration = 10,
			cookfx = {smoke=true,sizzle=(i==0)},
			indexkeys = {modname..":heater_"..tostring(i)},
			nodes = {
				{match = modname..":heater_"..tostring(i), replace = modname..":heater_"..tostring(i+1)}
			}
		})

		nodecore.register_craft({
			label = "heater cooling",
			action = "cook",
			touchgroups = {optic_lens_emit = 0},
			neargroups = {},
			duration = 10,
			priority = -1,
			cookfx = {hiss=(i==0),sizzle=false,smoke=true},
			indexkeys = {modname..":heater_"..tostring(i+1)},
			nodes = {
				{match = modname..":heater_"..tostring(i+1), replace = modname..":heater_"..tostring(i)}
			}
		})

		nodecore.register_craft({
			label = "heater burnfreezing",
			action = "cook",
			touchgroups = {},
			neargroups = {coolant=1},
			priority = 2,
			cookfx = {hiss=true},
			indexkeys = {modname..":heater_"..tostring(i+1)},
			nodes = {
				{match = modname..":heater_"..tostring(i+1), replace = modname..":heater_broken"}
			}
		})


end

nodecore.register_craft({
		label = "hot heater smoke effect",
		action = "cook",
		touchgroups = {optic_lens_emit = 1},
		neargroups = {},
		duration = 99999999999999999,
		priority = -2,
		cookfx = {smoke=true},
		indexkeys = {modname..":heater_7"},
		nodes = {
			{match = modname..":heater_7", replace = modname..":heater_7"}
		}
	})

--... and activate them

nodecore.register_cook_abm({
		nodenames = {"group:heater"},
		neighbors = {"group:optic_lens_emit"},
		neighbors_invert = true
	})
nodecore.register_cook_abm({
		nodenames = {"group:heater"},
		neighbors = {"group:coolant"},
		neighbors_invert = true
	})
nodecore.register_cook_abm({
		nodenames = {"group:heater"},
		neighbors_invert = true
	})



minetest.register_node(modname..":heater_7",{
	description = "Hot",
	tiles = {"nc_heater_7.png"},
	sounds = nodecore.sounds("nc_optics_glassy", nil, 0.5),
	light_source = 7,
	stack_max = 0,
	groups = {igniter=1, flame=1, damage_touch=1, damage_radiant=3,heater=1}
})
