--- @module add_child_org_consent
-- Adds a child org
-- Depends on `consent`

local add_child_org_consent = {
    name = "Add child org (consent)",
    slug = "add_child_org_consent",
    desc = "Create a child org in the current one with member consent"
}
add_child_org_consent.data = {
   child_name = "",
   result = nil
}
add_child_org_consent.config = {
}

-- @function initiate
function add_child_org_consent:initiate(result)
   modpol.interactions.text_query(
      self.initiator,"Child org name: ",
      function(input)
         if input == "" then
            modpol.interactions.message(
               self.initiator,
               "No name entered for child org")
            modpol.interactions.org_dashboard(
               self.initiator, self.org.name)
            self.org:delete_process(self.id)            
            if result then result() end
            return
         elseif modpol.orgs.get_org(input) then
            modpol.interactions.message(
               self.initiator,
               "Org name already in use")
            modpol.interactions.org_dashboard(
               self.initiator, self.org.name)
            self.org:delete_process(self.id)
            if result then result() end
            return
         end
         self.data.child_name = input
         modpol.interactions.message(
               self.initiator,
               "Proposed child org: " .. input)
         -- initiate consent process
         self.org:call_module(
            "consent",
            self.initiator, 
            {
               prompt = "Create child org " ..
                  self.data.child_name .. "?",
               votes_required = #self.org.members
            },
            function()
               self:create_child_org()
            end
         )
         modpol.interactions.org_dashboard(
            self.initiator, self.org.name)
      end
   )
end

function add_child_org_consent:create_child_org()
   self.org:add_org(self.data.child_name, self.initiator)
   modpol.interactions.message_org(
      self.initiator,
      self.org.name,
      "Child org created: "..self.data.child_name)
   if self.data.result then self.data.result() end
   self.org:delete_process(self.id)
end
      
--- (Required) Add to module table
modpol.modules.add_child_org_consent = add_child_org_consent
