--- remove_member_consent
-- @module remove_member_consent

local remove_member_consent = {
    name = "Remove a member (consent)",
    slug = "remove_member_consent",
    desc = "Removes org member with consent of other members"
}

remove_member_consent.data = {
   member_to_remove = "",
   result = nil
}

remove_member_consent.config = {
}

function remove_member_consent:initiate(result)
   -- Abort if in root org
   if self.org == modpol.instance then
      modpol.interactions.message(
         self.initiator,
         "Members cannot be removed from the root org")
      if result then result() end
      self.org:delete_process(self.id)
   else -- proceed if not root
      self.data.result = result
      modpol.interactions.dropdown_query(
         self.initiator,
         "Which member of org "..self.org.name..
         " do you want to remove?",
         self.org.members,
         function(input)
            self.data.member_to_remove = input
            self.org:call_module(
               "consent",
               self.initiator,
               {
                  prompt = "Remove "..input..
                     " from org "..self.org.name.."?",
                  votes_required = #self.org.members - 1
               },
               function()
                  self:complete()
            end)
            modpol.interactions.org_dashboard(
         self.initiator, self.org.name)
      end)
   end
end

function remove_member_consent:complete()
   modpol.interactions.message_org(
      self.initiator, self.org.id,
      "Consent reached: removing "..
      self.data.member_to_remove..
      " from org "..self.org.name)
   self.org:remove_member(self.data.member_to_remove)
   self.org:delete_process(self.id)
   if self.data.result then self.data.result() end
end

--- (Required) Add to module table
modpol.modules.remove_member_consent = remove_member_consent
