--- defer_consent
-- @module defer_consent

--- (Required): data table containing name and description of the module
-- @field name "Human-readable name (parens OK, no brackets)"
-- @field slug "Same as module class name"
-- @field desc "Description of the module"
-- @field hide "Whether this is a hidden utility module"
local defer_consent = {
    name = "Defer consent",
    slug = "defer_consent",
    desc = "Defers consent on a decision to another org",
    hide = true;
}

--- (Required) Data for module
-- Variables that module uses during the course of a process
-- Can be blank
defer_consent.data = {
}

--- (Required): config for module 
-- @field defer_org Name or ID of target org
-- @field votes_required Threshold passed on to `consent`
-- @field prompt String passed on to `consent`
defer_consent.config = {
   defer_org = "Root",
    votes_required = 1,
    prompt = "Do you consent?"
}

--- (Required): initiate function
-- @param result (optional) Callback if this module is embedded in other modules
-- @function initiate
function defer_consent:initiate(result)
   local defer_org = modpol.orgs.get_org(self.config.defer_org)
   if not defer_org then
      modpol.interactions.message(
         self.initiator, "Target org not found, aborting")
      self.org:delete_process(self.id)
   else
      defer_org:call_module(
         "consent", self.initiator,
         {
            votes_required = self.config.votes_required,
            prompt = self.config.prompt
         },
         function()
            if result then result() end
      end)
   end
   if result then result() end
   self.org:delete_process(self.id)
end

--- (Required) Add to module table
modpol.modules.defer_consent = defer_consent
