--- @module consent
-- A utility module for checking consent

local consent = {
    name = "Consent process",
    slug = "consent",
    desc = "A utility module other modules use for consent decisions",
    hide = true
}

consent.data = {
   votes = 0
}

consent.config = {
    prompt = "Do you consent?",
    votes_required = 1
}

function consent:initiate(result)
   self.data.result = result
   -- if org is empty, consent is given automatically
   if self.org:get_member_count() == 0 then
      if self.data.result then
         self.data.result() end
      self.org:delete_process(self.id)
   else
      -- otherwise, create poll
      for id, member in pairs(self.org.members) do
         self.org:add_pending_action(self.id, member, "callback")
      end
   end
end

function consent:callback(member)
    modpol.interactions.binary_poll_user(
        member,
        self.config.prompt,
        function (resp)
           self.org:remove_pending_action(self.id,member)
           if resp == "Yes" then
              self.data.votes = self.data.votes + 1
           end
           modpol.interactions.message_org(
              "consent", self.org.id,
              member.." decided "..resp.." on: "..
              self.config.prompt.." ("..self.data.votes..
              "/"..self.config.votes_required..")"
           )
           if self.data.votes >= self.config.votes_required then
              if self.data.result then
                 self.data.result() end
              self.org:delete_process(self.id)
           end
           modpol.interactions.org_dashboard(
              member, self.org.name)
        end
    )
end

modpol.modules.consent = consent
