--- create_token
-- @module create_token
-- depends on tokenomics

local create_token = {
    name = "Create a token (consent)",
    slug = "create_token",
    desc = "With org consent, creates an org token",
    hide = false;
}

--- (Required) Data for module
-- Variables that module uses during the course of a process
-- Can be blank
create_token.data = {
}

create_token.config = {
   token_name = ""
}

--- (Required): initiate function
-- @param result (optional) Callback if this module is embedded in other modules
-- @function initiate
function create_token:initiate(result)
   modpol.interactions.text_query(
      self.initiator,
      "Token name (alpha-numeric, no spaces):",
      function(input)
         self.config.token_name = input
         self.org:call_module(
            "tokenomics",
            self.initiator,
            {
               consent = true,
               token_slug = self.config.token_name
            },
            function(input2)
               modpol.interactions.org_dashboard(
                  self.initiator, self.org.name)
               if result then result() end
               -- call this wherever process might end:
               self.org:delete_process(self.id)
            end
         )
         modpol.interactions.org_dashboard(
            self.initiator, self.org.name)
      end
   )
end

--- (Required) Add to module table
modpol.modules.create_token = create_token
