--- Remove org (consent)
-- A simple module that calls a consent process on an org to remove it.
-- Depends on the Consent module.

local remove_org_consent = {
    name = "Remove this org (consent)",
    slug = "remove_org_consent",
    desc = "Removes an org if all members consent."
}

remove_org_consent.data = {
   result = nil
}

remove_org_consent.config = {
}

function remove_org_consent:initiate(result)
   if self.org == modpol.instance then
      modpol.interactions.message(
         self.initiator,
         "Cannot remove root org")
      if result then result() end
      self.org:delete_process(self.id)
   else
      self.data.result = result
      self:call_module(
        "consent", 
        self.initiator, 
        {
           prompt = "Remove org " .. self.org.name .. "?",
           votes_required = #self.org.members
        },
        function()
           self:complete()
        end
      )
      modpol.interactions.org_dashboard(
         self.initiator, self.org.name)
   end
end

function remove_org_consent:complete()
   modpol.interactions.message_org(
      self.initiator, self.org.id,
      "Consent reached: removing org " .. self.org.name)
   if self.data.result then self.data.result() end
   self.org:delete_process(self.id)
   self.org:delete()   
end

modpol.modules.remove_org_consent = remove_org_consent
