--- Rename org (consent)
-- A simple module that calls a consent process on an org to rename it.
-- Depends on the Consent module.

local rename_org_consent = {
    name = "Rename this org (consent)",
    slug = "rename_org_consent",
    desc = "Renames an org if all members consent."
}

rename_org_consent.data = {
   result = nil,
   new_name = nil
}

rename_org_consent.config = {
}

function rename_org_consent:initiate(result)
   modpol.interactions.text_query(
      self.initiator,"New org name: ",
      function(input)
         if input == "" then
            modpol.interactions.message(
               self.initiator,
               "No name entered for child org")
            modpol.interactions.org_dashboard(
               self.initiator, self.org.name)
            self.org:delete_process(self.id)            
            if result then result() end
            return
         elseif modpol.orgs.get_org(input) then
            modpol.interactions.message(
               self.initiator,
               "Org name already in use")
            modpol.interactions.org_dashboard(
               self.initiator, self.org.name)
            self.org:delete_process(self.id)
            if result then result() end
            return
         end
         self.data.new_name = input
         modpol.interactions.message(
               self.initiator,
               "Proposed to change name of org " ..
               self.org.name .. " to " .. input)
         -- initiate consent process
         self:call_module(
            "consent",
            self.initiator, 
            {
               prompt = "Change name of org " ..
                  self.org.name .. " to " .. input .. "?",
               votes_required = #self.org.members
            },
            function()
               self:complete()
            end
         )
         modpol.interactions.org_dashboard(
            self.initiator, self.org.name)
      end
   )
end

function rename_org_consent:complete()
   modpol.interactions.message_org(
      self.initiator,
      self.org.name,
      "Changing name of org " .. self.org.name ..
      " to " .. self.data.new_name)
   self.org.name = self.data.new_name
   if self.data.result then self.data.result() end
   self.org:delete_process(self.id)
end

modpol.modules.rename_org_consent = rename_org_consent
