--- Remove child (consent)
-- A simple module that calls a consent process on an org to remove its child
-- Depends on the Consent module.

local remove_child_consent = {
    name = "Remove child (consent)",
    slug = "remove_child_consent",
    desc = "Removes a child org if all members of this org consent."
}

remove_child_consent.data = {
   result = nil,
   child_to_remove = nil
}

remove_child_consent.config = {
}

function remove_child_consent:initiate(result)
   local children = {}
   for i,v in ipairs(self.org.children) do
      local child = modpol.orgs.get_org(v)
      if child then table.insert(children, child.name) end
   end
   -- Abort if no child orgs
   if #children == 0 then
      modpol.interactions.message(
         self.initiator,
         "Org has no children")
      if result then result() end
      self.org:delete_process(self.id)
   else
      self.data.result = result
      modpol.interactions.dropdown_query(
         self.initiator,
         "Choose a child of org "..
         self.org.name.." to remove:",
         children,
         function(input)
            self.data.child_to_remove = modpol.orgs.get_org(input)
            self:call_module(
               "consent",
               self.initiator,
               {
                  prompt = "Remove child org "..input.."?",
                  votes_required = #self.org.members
               },
               function()
                  self:complete()
            end)
            modpol.interactions.org_dashboard(
               self.initiator, self.org.name)
      end)
   end
end

function remove_child_consent:complete()
   modpol.interactions.message_org(
      self.initiator, self.data.child_to_remove.id,
      "Removing org " .. self.data.child_to_remove.name ..
      " by parent org consent")
   modpol.interactions.message_org(
      self.initiator, self.org.id,
      "Consent reached: removing org " ..
      self.data.child_to_remove.name)
   self.data.child_to_remove:delete()
   if self.data.result then self.data.result() end
   self.org:delete_process(self.id)
end

modpol.modules.remove_child_consent = remove_child_consent
