--- Defer consent
-- @module defer_consent

local defer_consent = {
    name = "Defer consent",
    slug = "defer_consent",
    desc = "Defers consent on a decision to another org",
    hide = true;
}

defer_consent.data = {
}

--- Config for module 
-- @field defer_org Name or ID of target org
-- @field votes_required Threshold passed on to `consent`
-- @field prompt String passed on to `consent`
defer_consent.config = {
   defer_org = "Root",
    votes_required = 1,
    prompt = "Do you consent?"
}

--- Initiate function
-- @param result Callback if this module is embedded in other modules
-- @function defer_consent:initiate
function defer_consent:initiate(result)
   local defer_org = modpol.orgs.get_org(self.config.defer_org)
   if not defer_org then
      modpol.interactions.message(
         self.initiator, "Target org not found, aborting")
      self.org:delete_process(self.id)
   else
      defer_org:call_module(
         "consent", self.initiator,
         {
            votes_required = self.config.votes_required,
            prompt = self.config.prompt
         },
         function()
            if result then result() end
      end)
   end
   if result then result() end
   self.org:delete_process(self.id)
end

--- (Required) Add to module table
modpol.modules.defer_consent = defer_consent
