--- Join org (consent).
-- A simple module that calls a consent process on an org to add a member.
-- Depends on the Consent module.
-- @module join_org_consent

local join_org_consent = {
    name = "Join this org (consent)",
    slug = "join_org_consent",
    desc = "Adds member with consent of all members"
}

join_org_consent.data = {
   result = nil
}

join_org_consent.config = {
}

--- Initiate join org with consent
-- @function join_org_consent:initiate
-- @param result Callback if this module is embedded in other modules
function join_org_consent:initiate(result)
   if self.org:has_member(self.initiator) then
      modpol.interactions.message(
         self.initiator,
         "You are already a member of this org")
      if result then result() end
      self.org:delete_process(self.id)
   else
      self.data.result = result
      self:call_module(
         "consent", 
         self.initiator, 
        {
            prompt = "Allow " .. self.initiator .. " to join?",
            votes_required = #self.org.members
        },
        function () 
            self:complete()
        end
    )
   end
end

--- Adds member to org, notifies org, and deletes process
-- @function join_org_consent:complete
function join_org_consent:complete()
   self.org:add_member(self.initiator)
   modpol.interactions.message_org(
      self.initiator,self.org.name,
      "Consent reached: " .. self.initiator ..
      " joined org " .. self.org.name)
   if self.data.result then self.data.result() end
   self.org:delete_process(self.id)
end

modpol.modules.join_org_consent = join_org_consent
