--- A simple module that removes an org.
-- @module remove_org

remove_org = {
    name = "Remove this org",
    slug = "remove_org",
    desc = "Eliminates the org and all child orgs."
}

remove_org.config = {}
remove_org.data = {}

--- Removes org
-- @function remove_org:initiate
-- @param result Callback if this module is embedded in other modules
function remove_org:initiate(result)
   if self.org == modpol.instance then
   modpol.interactions.message(
      self.initiator,
      "Cannot remove the root org")
   else
      modpol.interactions.message_org(
         self.initiator,self.org.id,
         "Removing org: "..self.org.name)
      self.org:delete()
      modpol.interactions.dashboard(self.initiator)
      -- call result function 
   end
   if result then result() end
end

modpol.modules.remove_org = remove_org
