--- Adds a user to org
-- @module join_org

join_org = {}

join_org.setup = {
   name = "Join Org",
   slug = "join_org",
   desc = "If consent process is passed, initiator joins this org."
}

--- Adds the user to the org
-- @function join_org.initiate
-- @param result Callback if this module is embedded in other modules
function join_org.initiate(result) 
    modpol.interactions.binary_poll_user(
        initiator, 
        "Would you like to join " .. org.name, 
        function (resp) 
            if resp == "Yes" then
                self.org:add_member(self.initiator)
            end
        end
    )

    for i, member in ipairs(self.org.members) do
        self.org:add_pending_action(
            member,
            function () 
                modpol.interactions.binary_poll_user(
                    member,
                    "Let " .. initiator .. " join " .. org.name .. "?",
                    function (resp)
                        
                    end
                )
            end
        )
    end

    if result then result() end
end

modpol.modules.join_org = join_org
