# Modpol for Minetest

Modpol, short for "modular politics," enables diverse governance processes on multi-user platforms. It offers a library with which users can choose, modify, and create modules that add specific governance functionalities.

This implementation is a mod for [Minetest](https://minetest.net), a free/open-source voxel game. It is designed to be adapted to other multi-user platforms that also employ Lua as an extension language.

## How to use it

Modpol is built around groups called *orgs*. At the base is an org with all users in it, called `Root` by default. *Modules* enable people to do things within orgs, such as decide on membership, grant powers to the org, and much more. To get started in Minetest:

* Type the command `/mp`
* Select the org `Root`
* Choose one of its modules to make new orgs and craft their behavior

![](lib/module_list.png)

Modules can be nested in each other, so one module can rely on another module to accomplish a process. Users might use a module to unilaterally carry out actions in the game, or the module might require a group decision to do so. Users can also change the modules available to users of a given org. There are currently two ways of doing this:

* Admins can remove modules from the list of modules loaded in `modpol_core/api.lua` and `modpol_minetest/api.lua`. This will make those modules no longer available to any user.
* Players can change the modules available in a given org from within the program using the `Change modules` module. Removed modules can be re-added in any org by using `Change modules` again.

Modpol should give you the ability to do whatever kind of politics you want with your modules. If there is something you would like to do that is not available, [develop a module for it](https://gitlab.com/medlabboulder/modpol/-/wikis/Module-Writing-Guide) (or ask us for help!).


## Installation in Minetest

To use this in Minetest, simply install it in your `mods/` or `worldmods/` folder. Minetest will load `init.lua`.

In the game, open the Modpol dashboard with the command `/mp`.

For testing purposes, players with the `privs` privilege (generally admins) can use the `/mp` command, which resets all the orgs and opens a dashboard.\


## Standalone Version on the Command Line

Modpol can also be used independently of Minetest as a command-line tool. Currently command-line use of modpol requires a Unix-style system, but it is intended to become more fully platform independent.

The command-line version is in the `modpol` subdirectory. To run the program on Unix systems in CLI mode, install lua or luajit and execute the following in this directory:

```
$ lua[jit] login.lua
```

Alternatively, to test arbitrary functions in the interpreter outside of the interactive dashboards, load Modpol's library with:

```
$ lua[jit]
> dofile("modpol_core/modpol.lua")
```

In the interpreter, for a list of global functions and tables, use `modpol.menu()`.

## Storage

The persistent storage method may be chosen in `modpol.lua`. If available, Modpol uses Minetest's built-in StorageRef system for Minetest 5.*. If that is not available, or in CLI mode, data will be stored in a data directory at `modpol_core/data/`. This will contain a log file and serialized program data files.


## Design philosophy

Modpol seeks to implement a theoretical framework called "[modular politics](https://metagov.org/modpol)," which proposes these design goals:

* *Modularity*: Platform operators and community members should have the ability to construct systems by creating, importing, and arranging composable parts together as a coherent whole.
* *Expressiveness*: The governance layer should be able to implement as wide a range of processes as possible.
* *Portability*: Governance tools developed for one platform should be portable to another platform for reuse and adaptation.
* *Interoperability*: Governance systems operating on different platforms and protocols should have the ability to interact with each other, sharing data and influencing each other's processes.

Additionally, Modpol seeks to counteract the tendency for "[implicit feudalism](https://ntnsndr.in/ImplicitFeudalism)," according to which rigid, top-down power structures are the norm in online spaces. To this end, some design patterns include:

* *Groups, not roles*: While most platforms assign powers through particular permissions given to individuals, in Modpol, power lies in groups (which Modpol calls "orgs").
* *Consent, not oligarchy*: Rather than assuming that decisions will be made by a few power-holders, the software assumes that consent by all affected users is the norm.
* *Inheritance, not blank slates*: When a new group is formed, it inherits the patterns of what preceded it, rather than imagining that it is starting from scratch.

It is certainly possible to use Modpol to replicate practices of implicit feudalism, such as all-powerful admins, but doing so requires extra work to overcome these defaults.

## Documentation

Various guides are available at the [GitLab wiki](https://gitlab.com/medlabboulder/modpol/-/wikis/home).

Read documentation of functions and modules at `docs/doc/index.html`. Documentation was generated using [LDoc](https://stevedonovan.github.io/ldoc/). To generate basic documentation for every page, download `ldoc` and use the following command:

```
$ cd docs/
$ ldoc ..
```

This will not generate the same index page and sidebar as the documentation provided; the appropriate structure needs to be added manually.

## Credits

This project is led by [Nathan Schneider](https://nathanschneider.info) of the [Media Enterprise Design Lab](https://colorado.edu/lab/medlab) at the University of Colorado Boulder, as part of the [Metagovernance Project](https://metagov.org).

Contributors include:

* [Luke Miller](https://gitlab.com/lukvmil) (co-leadership, main control flow, object orientation, module spec)
* [MisterE](https://gitlab.com/gbrrudmin) (early project refactoring, core feature development)
* Robert Kiraly [[OldCoder](https://github.com/oldcoder/)] (ocutils.lua, storage-local.lua, project refactoring)
* Skylar Hew (documentation)

We are grateful for initial support for this project from a residency with [The Bentway Conservancy](https://www.thebentway.ca/). Read about us in _[The Field Guide to Digital and/as Public Space](https://www.thebentway.ca/stories/field-guide/)_.


## Contributing

We'd love to welcome more contributors. Please join the conversation in the [Issues](https://gitlab.com/medlabboulder/modpol/-/issues), the \#modpol channel at the [Metagovernance Project](https://metagov.org) Slack, and the [Minetest.net forum](https://forum.minetest.net/viewtopic.php?f=47&t=26037).

Learn more about the project and how to develop your own modules in [the wiki](https://gitlab.com/medlabboulder/modpol/-/wikis/home).


## Licenses

* [Project](LICENSE.mt): MIT
* [Lua Serpent Serializer](serpent/LICENSE.txt): MIT
