local path = minetest.get_modpath"divine_tools"
local S = minetest.get_translator"divine_tools"

divine_tools = {}

divine_tools.get_translator = S
divine_tools.modpath = path

--
-- FUNCTIONS STOLEN FROM MOBKIT
--
local function exists(thing)
	if not thing then return false end
	if type(thing) == 'table' then thing=thing.object end
	if type(thing) == 'userdata' then 
		if thing:is_player() then
			if thing:get_look_horizontal() then return true end 
		else
			if thing:get_yaw() then return true end
		end
	end
end
local function is_alive(thing)		-- thing can be luaentity or objectref.
--	if not thing then return false end
	if not exists(thing) then return false end
	if type(thing) == 'table' then return thing.hp > 0 end
	if thing:is_player() then return thing:get_hp() > 0
	else 
		local lua = thing:get_luaentity()
		local hp = lua and (lua.hp or lua.health) or nil
		return hp and hp > 0
	end
end
local function play_sound(sound, obj)
	local param_table = {object = obj, gain = 1.0, pitch = 1.0, max_hear_distance = 512}
	minetest.sound_play(sound, param_table)
end

--
-- TOOL DEFINITIONS
--
minetest.register_tool("crucifix:crucifix", {
	description = S"Crucifix",
	inventory_image = "crucifix.png",
	groups = {divine = 1},
	on_secondary_use = function(itemstack, user, pointed_thing)
		local ref = pointed_thing.type == "object" and pointed_thing.ref
		if ref and is_alive(ref) then
			if ref:is_player() then
				ref:set_hp(0, {type="punch", object=user})
			else
				local ent = ref:get_luaentity()
				if ent then
					ref:punch(user, 1, {})
					ent.hp = 0
					ent.health = 0
				end
			end
			play_sound("crucifix_use", ref)
		end
	end,
	light_source = 14
})
--
-- CUT JUGGERRING
--
--[[
	minetest.register_tool("divine_tools:juggerring", {
		description = S"Juggerring",
		inventory_image = "divine_tools_juggerring.png",
		groups = {divine = 1, ring = 1},
		light_source = 14
	})

	minetest.register_on_player_hpchange(function(player, hp_change, reason)
		if hp_change < 0 or player:get_hp() <= 1 then
			local inv = player:get_inventory()
			local lists = inv:get_lists()
			for name,_ in pairs(lists) do
				if inv:contains_item(name, ItemStack("divine_tools:juggerring")) then
					player:set_hp((player.hp_max or minetest.PLAYER_MAX_HP_DEFAULT))
					return 1
				end
			end
		end
		return hp_change
	end, true)
--]]