--------------------------------
-- ALIASES ---------------------
--------------------------------
-- LIBRARY ALIASES -------------
local S = natural_entities.get_translator
local SPAWN_RATE = natural_entities.SPAWN_RATE
--------------------------------
-- COMMANDS --------------------
--------------------------------
-- PAUSE NATURAL ENTITIES ------
core.register_chatcommand("pause_natural_entities", {
	params = "",
	description = S"Pause the spawning of natural entities",
	privs = {server = true},
	func = function()
		natural_entities.pause()
		core.chat_send_all("Natural Entity spawning has been paused.")
	end
})
-- UNPAUSE NATURAL ENTITIES ----
core.register_chatcommand("unpause_natural_entities", {
	params = "",
	description = S"Unpause the spawning of natural entities",
	privs = {server = true},
	func = function(plyrname)
		if SPAWN_RATE == 0 then 
			return false, S"Natural Entities cannot spawn when Spawn rate is 0, change natural_entities_spawn_rate in minetest.conf and restart."
		end
		natural_entities.unpause()
		core.chat_send_all(S"Natural Entity spawning has been unpaused.")
	end
})
-- IS NATURAL ENTITIES PAUSED --
core.register_chatcommand("is_natural_entities_paused", {
	params = "",
	description = S"Check whether or not natural entities is paused",
	func = function(plyrname)
		if natural_entities.is_paused() then
			return true, S"Natural Entities is paused."
		else 
			return true, S"Natural Entities is not paused."
		end
	end
})
--------------------------------