---------------------
-- ALIASES ----------
---------------------
-- CORE ALIASES -----
local get_connected_players = core.get_connected_players
-- LIBRARY ALIASES --
local S = natural_entities.get_translator
local SPAWN_RATE = natural_entities.SPAWN_RATE
---------------------
if natural_entities.is_paused() then
	core.log("info", "Note: Natural Entities is paused. use /unpause_natural_entites to resume spawning entities.")
end
---------------------
-- LISTENERS --------
---------------------
-- GLOBALSTEP -------
local timers = {}
local index, player
local function globalstep(dtime)
	if natural_entities.is_paused() then return end

	index, player = next(get_connected_players(), index)

    if not index or not player or not player:is_valid() then return end

	local playername = player:get_player_name()

	timers[playername] = (timers[playername] or 0.0) + dtime
	if timers[playername] > SPAWN_RATE then
		-- don't use an alias here so that other mods can override it if they wish.
		natural_entities.spawnstep(player)
		timers[playername] = 0
	end
end
core.register_globalstep(globalstep)
-- JOINPLAYER -------
local function joinplayer(player)
	local playername = player:get_player_name()
	if core.get_player_privs(playername).server and natural_entities.is_paused() then 
		if SPAWN_RATE == 0 then
			core.chat_send_player(playername, "WARNING: spawnrate of 0 automatically disables natural entity spawning.")
		end
		core.chat_send_player(playername, "Note: Natural Entities is paused. use /unpause_natural_entites to resume spawning entities.")
	end
	timers[playername] = 0.0
end
core.register_on_joinplayer(joinplayer)
---------------------