# colorbrewer4minetest
A mod for implementing Prof. Cynthia Brewer's [colorbrewer palettes](https://github.com/axismaps/colorbrewer/) in Minetest for cartography. 

## Credit
The colorbrewer palettes were created by Prof. Cynthia Brewer at Pennsylvannia State University and licensed under an Aphache License 2.0. 

[Prof. Paul Pickell](https://github.com/pauldpickell) (University of British Columbia) implemented the palettes in 8-bit (256 colors) as an installable mod for Minetest. 

## Install the palettes
Unpackage the `colorbrewer` folder into your mod directory, located where ever you installed Minetest.

## Use
`colorbrewer4minetest` utilizes [hardware coloring](https://minetest.gitlab.io/minetest/textures/#hardware-coloring) and supports passing a `param2` value to a `colorbrewer` node. As of v1.0.0, the mod only registers the 27 colorbrewer palettes, which may be used by other mods.

Registered itemstrings below:
- `colorbrewer:BrBG`
- `colorbrewer:PiYG`
- `colorbrewer:PRGn`
- `colorbrewer:PuOr`
- `colorbrewer:RdBu`
- `colorbrewer:RdGy`
- `colorbrewer:RdYlBu`
- `colorbrewer:RdYlGn`
- `colorbrewer:Spectral`
- `colorbrewer:Blues`
- `colorbrewer:BuGn`
- `colorbrewer:BuPu`
- `colorbrewer:GnBu`
- `colorbrewer:Greens`
- `colorbrewer:Greys`
- `colorbrewer:Oranges`
- `colorbrewer:OrRd`
- `colorbrewer:PuBu`
- `colorbrewer:PuBuGn`
- `colorbrewer:PuRd`
- `colorbrewer:Purples`
- `colorbrewer:RdPu`
- `colorbrewer:Reds`
- `colorbrewer:YlGn`
- `colorbrewer:YlGnBu`
- `colorbrewer:YlOrBr`
- `colorbrewer:YlOrRd`

## Screenshots of Palettes
![](/colorbrewer_screenshot.png)
![](/colorbrewer_screenshot2.png)

## Screenshots of Sine Function
![](/colorbrewer_BrBG.png)
![](/colorbrewer_PiYG.png)
![](/colorbrewer_PRGn.png)
![](/colorbrewer_PuOr.png)
![](/colorbrewer_RdBu.png)
![](/colorbrewer_RdGy.png)
![](/colorbrewer_RdYlBu.png)
![](/colorbrewer_RdYlGn.png)
![](/colorbrewer_Spectral.png)
![](/colorbrewer_Blues.png)
![](/colorbrewer_BuGn.png)
![](/colorbrewer_BuPu.png)
![](/colorbrewer_GnBu.png)
![](/colorbrewer_Greens.png)
![](/colorbrewer_Greys.png)
![](/colorbrewer_Oranges.png)
![](/colorbrewer_OrRd.png)
![](/colorbrewer_PuBu.png)
![](/colorbrewer_PuBuGn.png)
![](/colorbrewer_PuRd.png)
![](/colorbrewer_Purples.png)
![](/colorbrewer_RdPu.png)
![](/colorbrewer_Reds.png)
![](/colorbrewer_YlGn.png)
![](/colorbrewer_YlGnBu.png)
![](/colorbrewer_YlOrBr.png)
![](/colorbrewer_YlOrRd.png)
