local thumb_range = tonumber(minetest.settings:get("h2g2_electronic_thumb_range")) or 5000
local thumb_min_distance = tonumber(minetest.settings:get("h2g2_electronic_thumb_min_distance")) or 50

local storage = core.get_mod_storage()

core.register_tool("h2g2:thumb", {
    description = "Electronic Sub-Etha Signaling Device",
    inventory_image = "h2g2_thumb.png",
    light_source = 5,
    on_use = function(itemstack, player, pointed_thing)
        local pos = player:get_pos()
        local name = player:get_player_name()
        local pads = core.deserialize(storage:get_string("h2g2_pads"))
        local node_pos = nil
        if pads then
            for _,pad in ipairs(pads) do
                local distance = vector.distance(pos,pad)
                if distance > thumb_min_distance and node_pos == nil then
                    node_pos = pad
                elseif distance > thumb_min_distance and distance < vector.distance(pod, node_pos) then
                    node_pos = pad
                end
            end
        end
        core.chat_send_player(name, "Sending Sub-Etha Signal...")
        core.after(3, function(node_pos, player, name)
            if node_pos then
                core.chat_send_player(name, "Want a ride, Hitchhiker?")
                local to_pos = vector.add(node_pos, {x=0, y=1.5, z=0})
                player:set_pos(to_pos)
            else
                core.chat_send_player(name, "Nobody is around.")
            end
        end, node_pos, player, name)
    end
})
core.register_alias("thumb","h2g2:thumb")
core.register_alias("sub etha signalling device","h2g2:thumb")
core.register_node("h2g2:matter_transference_pad",{
    description = "Matter Transference Pad",
    drawtype = "nodebox",
    tiles = {
        "h2g2_matter_transference_pad.png",
        "h2g2_matter_transference_pad.png",
        "h2g2_matter_transference_pad.png",
        "h2g2_matter_transference_pad.png",
        "h2g2_matter_transference_pad.png",
        "h2g2_matter_transference_pad.png"
    },
    paramtype = "light",
    groups = { cracky = 1, oddly_breakable_by_hand = 1 },
    is_ground_content = false,
    light_source = 5,
    node_box = {
        type = "fixed",
        fixed = {
            {-0.9375, -0.5, -0.75, 0.875, -0.375, 0.75},
            {-0.8125, -0.5, -0.875, 0.75, -0.375, 0.875}, -- NodeBox2
            {-0.875, -0.5, -0.8125, 0.8125, -0.375, 0.8125}, -- NodeBox3
            {-0.8125, -0.5, -0.75, 0.75, -0.3125, 0.75},
        },
    },
    on_construct = function(pos)
        local pads = core.deserialize(storage:get_string("h2g2_pads"))
        local meta = core.get_meta(pos)
        if pads == nil then
            pads = {}
        end
        local id = #pads + 1
        pads[id] = pos
        meta:set_int("h2g2_pad_id",id)
        storage:set_string("h2g2_pads", core.serialize(pads))
    end,
    on_destruct = function(pos)
        local pads = core.deserialize(storage:get_string("h2g2_pads"))
        if pads ~= nil then
            local meta = core.get_meta(pos)
            local id = meta:get_int("h2g2_pad_id")
            table.remove(pads, id)
            storage:set_string("h2g2_pads", core.serialize(pads))
        end
    end
})
