local sensor_range = tonumber(core.settings:get("h2g2_heart_of_gold_sensor_range")) or 6
local range_limit = tonumber(core.settings:get("h2g2_heart_of_gold_range_limit")) or 200

local storage = core.get_mod_storage()

local function pos_safe(pos)
    local dest = core.get_node(pos)
    if dest.name == "air" or dest.name == "h2g2:lint" then
        -- only teleport to places where there's air
        return true
    else
        return false
    end
end
local function get_location(src_pos, count)
    if count == nil then count = 0 end
    local newpos = {}
    local lints = core.deserialize(storage:get_string("h2g2_lints"))
    if lints == nil then
        lints = {}
    end
    core.log("info","[h2g2] Lints: "..dump(lints))
    -- if we have lint, we want to prefer those locations
    local weighted_random = math.random(0,10)
    if #lints == 0 or weighted_random == 3 then
        --if #lints == 0 and weighted_random == 3 then
        -- find a random location
        newpos.x = math.random(src_pos.x - range_limit, src_pos.x + range_limit)
        -- probably wise to always teleport above land
        -- and at a height only a little above the source location
        newpos.y = math.random(5, src_pos.y + range_limit / 2)
        newpos.z = math.random(src_pos.z - range_limit, src_pos.z + range_limit)
        -- and put 0.5 above overwise we'll spawn in a block
        newpos.y = newpos.y + 0.5
        if pos_safe(newpos) then
            return newpos
        elseif count < 11 then
            return get_location(src_pos, count + 1)
        end
    elseif #lints > 0 then
        local random = math.random(1,#lints)
        local lint = lints[random]
        if lint ~= nil then
            core.log("info","[h2g2] Lint "..random.." selected.")
            return lint
        end
    end
end
local function improbability_teleport(src_pos, player)
    local name = player:get_player_name()
    core.chat_send_player(name,"Calculating Improbability...")
    local newpos = get_location(src_pos)
    if newpos ~= nil then
        local fake_improbability = math.random(2000000,3000000)
        core.log("info","Improbably teleporting "..name.." to "..
        newpos.x..","..newpos.y..","..newpos.z)
        player:set_pos(newpos)
        core.chat_send_player(name,"Cruising at 2 to the power of "..
        fake_improbability.." against, and falling...")
        core.after(3, function(name)
            core.chat_send_player(name,"Probability factor of 1 to 1 achieved."..
            "We have normality.")
        end, name)
    else
        core.chat_send_player(name,"Not enough Brownian Motion")
    end
end

local function search_for_players(pos, send_empty)
    local meta = core.get_meta(pos)
    local radius = meta:get_int("radius")
    local found = {}
    for _,player in pairs(core.get_connected_players()) do
        if vector.distance(pos, player:get_pos()) <= radius then
            table.insert(found, player)
        end
    end
    if #found > 0 or send_empty == true then
        for _,player in ipairs(found) do
            local name = player:get_player_name()
            core.log("info", "[h2g2] Improbably Found "..name)
            improbability_teleport(pos, player)
        end
    end
    return true
end

local function make_beam(pos, dir, count)
    if count == nil then count = range_limit end
    local d = "v"
    if dir == "l" or dir == "r" or dir == "f" or dir == "b" then
        d = "h"
    end
    local vec = {x=-1,y=0,z=0}
    if dir == "r" then
        vec = {x=1,y=0,z=0}
    elseif dir == "f" then
        vec = {x=0,y=0,z=1}
    elseif dir == "b" then
        vec = {x=0,y=0,z=-1}
    elseif dir == "u" then
        vec = {x=0,y=1,z=0}
    elseif dir == "d" then
        vec = {x=0,y=-1,z=0}
    end
    local node = vector.add(pos, vec)
    if core.get_node(node).name == "air" and count > 0 then
        core.set_node(node, { name = "h2g2:beam"..d})
        make_beam(node, dir, count - 1)
    end
end
local function stop_beam(pos, dir, count)
    if count == nil then count = range_limit end
    local d = "v"
    if dir == "l" or dir == "r" or dir == "f" or dir == "b" then
        d = "h"
    end
    local vec =  {x=-1,y=0,z=0}
    if dir == "r" then
        vec = {x=1,y=0,z=0}
    elseif dir == "f" then
        vec = {x=0,y=0,z=1}
    elseif dir == "b" then
        vec = {x=0,y=0,z=-1}
    elseif dir == "u" then
        vec = {x=0,y=1,z=0}
    elseif dir == "d" then
        vec = {x=0,y=-1,z=0}
    end
    local next = vector.add(pos, vec)
    if core.get_node(next).name == "h2g2:beam"..d and count > 0 then
        core.remove_node(next)
        stop_beam(next,dir,count - 1)
    end
end
local function make_beams(pos)
    for _,x in ipairs({"l","r","f","b","u","d"}) do
        make_beam(pos,x)
    end
end
local function stop_beams(pos)
    print(dump(pos))
    for _,x in ipairs({"l","r","f","b","u","d"}) do
        stop_beam(pos,x)
    end
end
core.register_node("h2g2:heart_of_gold", {
    description = "The Heart of Gold",
    tiles = {"h2g2_golden_bail_of_prosperity.png"},
    groups = { cracky = 1 },
    drawtype = "plantlike",
    on_construct = function(pos)
        local meta = core.get_meta(pos)
        meta:set_int("radius", sensor_range)
    end,
    after_place_node = function(pos, placer, itemstack, pointed_thing)
        local meta = core.get_meta(pos)
        local owner = placer:get_player_name()
        meta:set_string("owner",owner)
        meta:set_string("infotext","Heart of Gold\n" ..
        "("..owner..")")
    end,
    on_rightclick = function(pos, node)
        core.swap_node(pos, {name = "h2g2:heart_of_gold_active"})
        core.get_node_timer(pos):start(2)
        make_beams(pos)
    end
})
core.register_node("h2g2:heart_of_gold_active", {
    description = "The Heart of Gold",
    tiles = {"h2g2_golden_bail_of_prosperity.png"},
    groups = { not_in_creative_inventory = 1 },
    damage_per_second = 1,
    drawtype = "plantlike",
    light_source = core.LIGHT_MAX,
    on_timer = search_for_players,
    on_rightclick = function(pos, node)
        core.get_node_timer(pos):stop()
        core.swap_node(pos, {name = "h2g2:heart_of_gold"})
        stop_beams(pos)
    end,
})
core.register_alias("heart_of_gold","h2g2:heart_of_gold")
core.register_alias("golden_bail_of_prosperity","h2g2:heart_of_gold")
core.register_node("h2g2:beamh", {
    description = "Heart of Gold Active Beam Horizontal",
    --        drawtype = "plantlike",
    drawtype = "firelike",
    tiles = {"h2g2_beamh.png"},
    paramtype = "light",
    sunlight_propagates = true,
    light_source = core.LIGHT_MAX,
    walkable = false,
    pointable = false,
    diggable = false,
    buildable_to = true,
    floodable = false,
    drop = "",
    groups = { h2g2_light_beam = 1, not_in_creative_inventory = 1},
    damage_per_second = 1,
})
core.register_node("h2g2:beamv", {
    description = "Heart of Gold Active Beam Vertical",
    drawtype = "plantlike",
    tiles = {"h2g2_beamv.png"},
    paramtype = "light",
    sunlight_propagates = true,
    light_source = core.LIGHT_MAX,
    walkable = false,
    pointable = false,
    diggable = false,
    buildable_to = true,
    floodable = false,
    drop = "",
    groups = { h2g2_light_beam = 1, not_in_creative_inventory = 1},
    damage_per_second = 1,
})
core.register_node("h2g2:lint", {
    description = "Lint",
    drawtype = "plantlike",
    tiles = {"h2g2_lint.png"},
    groups = { cracky = 1, oddly_breakable_by_hand = 1 },
    paramtype = "light",
    walkable = false,
    sunlight_propagates = true,
    on_construct = function(pos)
        local lints = core.deserialize(storage:get_string("h2g2_lints"))
        local meta = core.get_meta(pos)
        if lints == nil then
            lints = {}
        end
        local id = #lints + 1
        lints[id] = pos
        meta:set_int("h2g2_lint_id", id)
        storage:set_string("h2g2_lints", core.serialize(lints))
    end,
    on_destruct = function(pos)
        local lints = core.deserialize(storage:get_string("h2g2_lints"))
        local meta = core.get_meta(pos)
        local id = meta:get_int("h2g2_lint_id")
        if lints ~= nil and id ~= nil then
            table.remove(lints, id)
            storage:set_string("h2g2_lints", core.serialize(lints))
        end
    end,
})
