local pov_range = 300

local function fire_pov(itemstack, player, pointed_thingy)
    local eye_pos = player:get_pos()
    local look = player:get_look_horizontal()
    local yaw = player:get_look_vertical()
    eye_pos.y = eye_pos.y + player:get_properties().eye_height
    local first, third = player:get_eye_offset()
    if not vector.equals(first, third) then
        core.log("warning", "First & third person eye offsets don't match, assuming first person")
    end
    -- eye offsets are in block space (10x), transform them back to metric
    eye_pos = vector.add(eye_pos, vector.divide(first, 10))
    local def = player:get_wielded_item():get_definition()
    for pointed_thing in core.raycast(eye_pos,
        vector.add(eye_pos,
        vector.multiply(player:get_look_dir(), pov_range)),
        true, def.liquids_pointable) do
        if pointed_thing.ref ~= player then -- exclude the player
            if pointed_thing.type == "object" then
                local obj = pointed_thing.ref
                local next_pos = eye_pos
                next_pos.x = next_pos.x + 1
                obj:move_to(eye_pos)
                if obj:is_player() then
                    obj:set_look_horizontal(look)
                    obj:set_look_vertical(yaw)
                end
                break
            end
            -- do something
        end
    end

end

core.register_tool("h2g2:pov_gun", {
    description = "Point of View Gun",
    inventory_image = "h2g2_pov_gun.png",
    on_use = fire_pov
})

