local colours = {
    "blue",
    "white",
    "beige",
    "black"
}
local storage = core.get_mod_storage()

local function add_pad(pos)
    local pads = core.deserialize(storage:get_string("h2g2_pads"))
    local meta = core.get_meta(pos)
    if pads == nil then
        pads = {}
    end
    local id = #pads + 1
    pads[id] = pos
    meta:set_int("h2g2_pad_id",id)
    storage:set_string("h2g2_pads", core.serialize(pads))
end
local function remove_pad(pos)
    local pads = core.deserialize(storage:get_string("h2g2_pads"))
    if pads ~= nil then
        local meta = core.get_meta(pos)
        local id = meta:get_int("h2g2_pad_id")
        table.remove(pads, id)
        -- Then just make sure there's no other remaining pads in that position
        for idx, pad in ipairs(pads) do
            if pad.x == pos.x and pad.y == pos.y and pad.z == pos.z then
                table.remove(pads, idx)
            end
        end
        -- Send the updated pad list to the storage
        storage:set_string("h2g2_pads", core.serialize(pads))
    end
end

for _, colour in ipairs(colours) do
    core.register_node("h2g2:towel_"..colour, {
        description = "Towel ("..colour..")",
        inventory_image = "h2g2_towel_"..colour..".png",
        tiles = {
            "h2g2_towel_"..colour..".png",
            "h2g2_towel_"..colour..".png",
            "h2g2_towel_"..colour.."_side2.png",
            "h2g2_towel_"..colour.."_side.png",
            "h2g2_towel_"..colour.."_top.png",
            "h2g2_towel_"..colour..".png"
    },
        drawtype = "nodebox",
        groups = { crumbly = 1, oddly_breakable_by_hand = 1 },
        node_box = {
            type = "fixed",
            fixed = {
                {-0.375, -0.5, -0.5, 0.31, -0.3125, 0.375}, -- NodeBox1
            }
        },
        on_secondary_use = function(itemstack, player, pointed_thing)
            player:set_hp(player:get_hp() + 3)
        end,
        on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
            core.swap_node(pos, {name = "h2g2:towel_"..colour.."_unfurled"})
            add_pad(pos)
        end,
        on_destruct = function(pos)
            -- shouldn't ever happen, but put here just in case
            remove_pad(pos)
        end,
    })
    core.register_node("h2g2:towel_"..colour.."_unfurled", {
        description = "Towel ("..colour..") Unfurled",
        tiles = { "h2g2_towel_"..colour.."_unfurled.png" },
        drawtype = "nodebox",
        node_box = {
            type = "fixed",
            fixed = {
                {-0.6, -0.5, -1, 0.6, -0.4375, 1}, -- NodeBox1
            }
        },
        groups = { cracky = 1, oddly_breakable_by_hand = 1, not_in_creative_inventory = 1 },
        drop = "h2g2:towel_"..colour,
        is_ground_content = false,
        on_construct = function(pos)
            add_pad(pos)
        end,
        on_destruct = function(pos)
            remove_pad(pos)
        end,
        on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
            core.swap_node(pos, {name = "h2g2:towel_"..colour})
            remove_pad(pos)
        end
    })
end
core.register_alias("h2g2:matter_transference_pad","h2g2:towel_blue_unfurled")
