
function toggle_bussard(pos)
    local thisnode = core.get_node(pos)
    local p1 = vector.add(pos,{ x = 1, y = 1, z = 1})
    local p2 = vector.add(pos,{ x = -1, y = -1, z = -1})
    if thisnode.name == "stnodes:bussard_block" then
        core.swap_node(pos, {name="stnodes:bussard_block_active"})
        core.after(0.4, function()
            local nodes = core.find_nodes_in_area(p1,p2,{"stnodes:bussard_block"})
            for _, node in ipairs(nodes) do
                toggle_bussard(node)
            end
        end)
    elseif thisnode.name == "stnodes:bussard_block_active" then
        core.swap_node(pos, {name="stnodes:bussard_block"})
        core.after(0.4, function()
            local nodes = core.find_nodes_in_area(p1,p2,{"stnodes:bussard_block_active"})
            for _, node in ipairs(nodes) do
                toggle_bussard(node)
            end
        end)
    end
    local timer = core.get_node_timer(pos)
    if timer ~= nil then
        timer:start(3)
    end
end
function enable_bussard(pos)
    local thisnode = core.get_node(pos)
    local p1 = vector.add(pos,{ x = 1, y = 1, z = 1})
    local p2 = vector.add(pos,{ x = -1, y = -1, z = -1})
    if thisnode.name == "stnodes:bussard_block" then
        core.swap_node(pos, { name = "stnodes:bussard_block_active"})
        core.after(0.4, function()
            local nodes = core.find_nodes_in_area(p1,p2,{"stnodes:bussard_block",
                                 "stnodes:bussard_block_active","stnodes:bussard_block_spent"})
            for _,nodepos in ipairs(nodes) do
                local thatnode = core.get_node(nodepos)
                if thatnode.name == "stnodes:bussard_block" then
                    enable_bussard(nodepos)
                elseif thatnode.name == "stnodes:bussard_block_active" then
                    local timer = core.get_node_timer(nodepos)
                    if timer ~= nil then
                        timer:start(0.5)
                    end
                elseif thatnode.name == "stnodes:bussard_block_spent" then
                    local timer = core.get_node_timer(nodepos)
                    if timer ~= nil then
                        timer:start(0.5)
                    end
                end
            end
        end)
    end
end
function disable_bussard(pos)
    local node = core.get_node(pos)
    if node.name == "stnodes:bussard_block_spent" then
        core.swap_node(pos,{ name = "stnodes:bussard_block"})
    elseif node.name == "stnodes:bussard_block_active" then
        core.swap_node(pos,{ name = "stnodes:bussard_block_spent"})
        local timer = core.get_node_timer(pos)
        if timer ~= nil then
            timer:start(0.5)
        end
    end
end

core.register_node("stnodes:bussard_block",{
    description = "Bussard Collector Block",
    tiles = {"bussard_tos.png"},
    groups = { cracky = 1 },
})
core.register_node("stnodes:bussard_block_spent",{
    description = "Bussard Collector Block (Spent)",
    tiles = {"bussard_tos.png"},
    groups = { cracky = 1, not_in_creative_inventory = 1 },
    paramtype = "light",
    light_source = 7,
    drop = "stnodes:bussard_block",
    on_timer = function(pos)
        disable_bussard(pos)
    end
})

core.register_node("stnodes:bussard_block_active",{
    description = "Bussard Collector Block (Active)",
    tiles = {"bussard_tos.png"},
    groups = { cracky = 1, not_in_creative_inventory = 1 },
    paramtype = "light",
    light_source = core.LIGHT_MAX,
    drop = "stnodes:bussard_block",
    on_timer = function(pos)
        disable_bussard(pos)
    end
})


local powered_items = {
    "stnodes:bussard_block"
}
local function list_contains(list, name)
    for _,item in ipairs(list) do
        if name == item then
            return true
        end
    end
    return false
end
local toggle_timer = function (pos)
    local timer = core.get_node_timer(pos)
    if timer:is_started() then
        timer:stop()
    else
        timer:start(4)
    end
end

local cardinals = {
    {x = -1, y = 0, z = 0},
    {x = 1, y = 0, z = 0},
    {x = 0, y = -1, z = 0},
    {x = 0, y = 1, z = 0},
    {x = 0, y = 0, z = 1},
    {x = 0, y = 0, z = -1},
}
local on_timer = function (pos)
    for _,cpos in ipairs(cardinals) do
        local npos = vector.add(pos,cpos)
        local node = core.get_node(npos)
        if list_contains(powered_items, node.name) then
            if node.name == "stnodes:bussard_block" then
                enable_bussard(npos)
            end
        end
    end
    toggle_timer(pos)
end

core.register_node("stnodes:power_source", {
    description = "Power Source",
    tiles = {"power_source.png"},
    groups = { cracky = 1 },
    on_timer = on_timer,
    on_construct = toggle_timer
})
core.register_alias("stnodes:bussard_power_source","stnodes:power_source")
