
local storage = core.get_mod_storage()


function get_ship(shipname)
	-- get the ship position from storage and return it
	local ships = core.deserialize(storage:get_string("stnodes:transporters"))
	if ships ~= nil then
		for idx,ship in pairs(ships) do
			if ship.name == shipname then
				return ship
			end
		end
	end
end

function set_next_transporter(ship,idx)
	local ships = core.deserialize(storage:get_string("stnodes:transporters"))
	if ships ~= nil then
		ship.pads[idx].next = false
		local newnext = idx + 1
		if newnext > #ship.pads then
			newnext = 1
		end
		ship.pads[newnext].next = true
		ships[ship.name].pads = ship.pads
	end
	storage:set_string("stnodes:transporters",core.serialize(ships))
end

function get_next_transporter(ship)
	if ship ~= nil then
		for idx,pad in ipairs(ship.pads) do
			if pad.next then
				set_next_transporter(ship,idx)
				return pad
			end
		end
	end
end

function find_transporter(name)
	local transporters = core.deserialize(storage:get_string("stnodes:transporters"))
	for _,t in pairs(transporters) do
		if t.name == name then
			return t
		end
	end
end

function add_particles(pos, time)
	if time == nil then
		time = 2.5
	end
	core.add_particlespawner(
		200, --amount
		time, -- time
		{x=pos.x-0.4, y=pos.y-0.2, z=pos.z-0.4}, --minpos
		{x=pos.x+0.4, y=pos.y+0.2, z=pos.z+0.4}, --maxpos
		{x=0, y=1, z=0}, --minvel
		{x=0, y=2, z=0}, --maxvel
		{x=-0,y=0,z=-0}, --minacc
		{x=0,y=5,z=0}, --maxacc
		0.5, --minexptime
		1, --maxexptime
		1, --minsize
		3, --maxsize
		false, --collisiondetection
		"transporter_particles.png" --texture
	)
end

local function get_nodes_above_below(pos)
	local node_at = core.get_node(pos)
	local node_above = core.get_node({x=pos.x,y=pos.y+1,z=pos.z})
	local node_below = core.get_node({x=pos.x,y=pos.y-1,z=pos.z})
	return { at = node_at, above = node_above, below = node_below}
end
local function get_nodes_at_pos(pos)
	local nodes = get_nodes_above_below(pos)
	if nodes.at.name == "ignore" or
		nodes.above.name == "ignore" or
		nodes.below.name == "ignore" then
		emerge_around(pos,2)
		core.after(2,function()
			return get_nodes_above_below(pos)
		end)
	else
		return nodes
	end
end
function transport_player(player,to_pos)
	emerge_around(to_pos,3)
	local my_pos = player:get_pos()
	--to_pos.y = to_pos.y
	player:set_physics_override({ speed = 0, jump = 0 })
	add_particles(my_pos)
	core.after(1, function()
		add_particles(to_pos,3)
	end)
	core.after(2, function()
		local velo = player:get_velocity()
		if velo.y < -9.81 then
			player:add_velocity({x=0,y=6.5,z=0})
		end
		player:set_pos(to_pos)
		core.after(2, function()
			player:set_physics_override({ speed = 1, jump = 1 })
		end)
	end)
end


function is_in_pos(pl_pos, pos)
	local from = { x=pos.x-0.5, y=pos.y-0.5, z=pos.z-0.5}
	local to = { x=pos.x+0.5, y=pos.y+0.5, z=pos.z+0.5}
	if pl_pos.x > from.x and pl_pos.x < to.x and
		pl_pos.y > from.y and pl_pos.y < to.y and
		pl_pos.z > from.z and pl_pos.z < to.z then
		return true
	end
end
local function find_safe_height(pos, noemerge, count)
	if count == nil then count = 0 end
	if noemerge ~= true then
		emerge_around(pos,3)
	end
	local node_at = core.get_node(pos)
	if node_at.name == "air" then
		return pos.y
	elseif node_at.name == "ignore" and count > 1000 then
		return find_safe_height(pos, true, count + 1)
	elseif count < 1000 then
		local up_pos = vector.add(pos,{x=0,y=1,z=0})
		return find_safe_height(up_pos, true, count + 1)
	else
		return pos
	end
end
function pad_transport_to(transporter, to_pos)
	emerge_around(to_pos,3)
	local t = find_transporter(transporter)
	local rear = get_rear_vector(t.pos,10)
	local focus = vector.add(t.pos,rear)
	if t ~= nil then
		for _,pad in ipairs(t.pads) do
			local to_jitter = vector.subtract(focus,pad.pos)
			for _,player in pairs(core.get_connected_players()) do
				local pl_pos = player:get_pos()
				if is_in_pos(pl_pos,pad.pos) then
					core.chat_send_player(player:get_player_name(), "Beaming down")
					local new_pos = vector.add(to_pos,to_jitter)
					new_pos.y = find_safe_height(new_pos)
					transport_player(player,new_pos)
				end
			end
		end
	end
end
function try_pad_transport_to(id, new_pos, player)
	local nodes = get_nodes_at_pos(new_pos)
	if nodes ~= nil then
		if id ~= nil and id ~= "" then
			core.chat_send_player(player:get_player_name(), "Beaming to...("..new_pos.x..", "..new_pos.y..", "..new_pos.z..")")
			core.chat_send_player(player:get_player_name(),
			"Attempting Transport in 5 seconds")
			core.after(5, function()
				pad_transport_to(id,new_pos)
			end)
		else
			core.chat_send_player(player:get_player_name(),
			"Error in Transport. Failed to find ship")
		end
	else
		core.chat_send_player(player:get_player_name(),
		"Temporary Error in Transport. The destination may not have been emerged. Please try again.")
	end
end

function transport(player, shipname)
	local ship = get_ship(shipname)
	local ship_pos = get_next_transporter(ship)
	if ship_pos ~= nil then
		core.chat_send_player(player:get_player_name(),shipname.." is beaming you up")
		local to_pos = ship_pos.pos
		transport_player(player, to_pos)
	else
		core.chat_send_player(player:get_player_name(),"Failed to find ship: "..shipname)
	end
end

function get_ship_names()
	local ships = core.deserialize(storage:get_string("stnodes:transporters"))
	local names = {}
	if ships ~= nil then
		for i,ship in pairs(ships) do
			if ship.enabled then
				table.insert(names,ship.name)
			end
		end
	end
	return names
end

local transporter_pad_nodebox = {
	type = "fixed",
	fixed = {
		{-0.25, -0.5, -0.5, 0.25, -0.4375, 0.5}, -- NodeBox1
		{-0.5, -0.5, -0.25, 0.5, -0.4375, 0.25}, -- NodeBox2
		{-0.3125, -0.5, -0.4375, 0.3125, -0.4375, 0.4375}, -- NodeBox3
		{-0.375, -0.5, -0.375, 0.375, -0.4375, 0.375}, -- NodeBox4
		{-0.4375, -0.5, -0.3125, 0.4375, -0.4375, 0.3125}, -- NodeBox5
	}
}

core.register_node("stnodes:transporter_pad",{
	description = "Transporter Pad",
	tiles = {"transporter_pad.png"},
	groups = { cracky = 1 },
	drawtype = "nodebox",
	paramtype = "light",
	node_box = transporter_pad_nodebox
})
core.register_node("stnodes:transporter_pad_active",{
	-- can't be destroyed when active - transporter console must be
	-- disabled before
	description = "Transporter Pad Active",
	tiles = {
		"transporter_pad.png",
		"duranium.png",
	},
	groups = { not_in_creative_inventory = 1 },
	drawtype = "nodebox",
	paramtype = "light",
	light_source = core.LIGHT_MAX,
	node_box = transporter_pad_nodebox
})

local console_nodebox = {
	type = "fixed",
	fixed = {
		{-0.5, -0.5, -0.5, 0.5, -0.4375, 0.5}, -- NodeBox1
		{-0.5, -0.5, 0.3125, 0.5, -0.3125, 0.5}, -- NodeBox2
		{0.250, -0.5, -0.3125, 0.5, -0.3125, 0.5}, -- NodeBox3
	}
}
local console_r_nodebox = {
	type = "fixed",
	fixed = {
		{-0.5, -0.5, -0.5, 0.5, -0.4375, 0.5}, -- NodeBox1
		{-0.5, -0.5, 0.3125, 0.5, -0.3125, 0.5}, -- NodeBox2
		{-0.250, -0.5, -0.3125, -0.5, -0.3125, 0.5}, -- NodeBox3
	}
}
local lhs_fs = "formspec_version[4]" ..
"size[5,4]" ..
"label[0.5,0.5;4,1;Transporter Setup]"..
"field[0.5,1.5;4,1;transporter_id;Transporter Name;${stnodes:transporter_id}]" ..
"button_exit[0.5,2.5;2,1;enable;Enable]"..
"button_exit[2.5,2.5;2,1;disable;Disable]"
local rhs_fs = "formspec_version[4]" ..
"size[10,8]" ..
"label[0.5,0.5;4,1;Transporter Control]"..
"field[0.5,1.5;3,1;xpos;Xpos;${stnodes_last_xpos}]" ..
"field[0.5,3;3,1;ypos;Ypos;${stnodes_last_ypos}]" ..
"field[0.5,4.5;3,1;zpos;Zpos;${stnodes_last_zpos}]" ..
"button[0.5,6;3,1;check_pos;Check Position]" ..
"button_exit[4.5,6;3,1;transport_to_pos;Transport To Position]" ..
"field[5.5,1.5;3,1;player;Player;]" ..
"button_exit[5.5,3;3,1;transport_to_player;Transport To Player]"
core.register_node("stnodes:transporter_console",{
	description = "Transporter Console",
	tiles = {
		"transporter_console_top.png",
		"duranium.png",
	},
	groups = { cracky = 1 },
	drawtype = "nodebox",
	paramtype = "light",
	paramtype2 = "facedir",
	node_box = console_nodebox,
	light_source = 4,
	after_place_node = function(pos, placer, itemstack, pointed_thing)
		local node = core.get_node(pos)
		local right = get_pos_to_right(pos)
		local rightnode = core.get_node(right)
		if rightnode.name == "air" then
			core.swap_node(right, {name = "stnodes:transporter_console_r", param2=node.param2 })
			local lhs_meta = core.get_meta(pos)
			lhs_meta:set_string("formspec",lhs_fs)
			local owner = placer:get_player_name()
			lhs_meta:set_string("owner",owner)
			if right ~= nil then
				local rhs_meta = core.get_meta(right)
				rhs_meta:set_string("formspec",rhs_fs)
				rhs_meta:set_string("owner",owner)
			end
		else
			core.chat_send_player(placer:get_player_name(),"Can't place that here")
			core.swap_node(pos,{name="air"})
			return
		end
	end,
	on_receive_fields = function(pos, formname, fields, player)
		local meta = core.get_meta(pos)
		local owner = meta:get_string("owner")
		local rhs_meta = core.get_meta(get_pos_to_right(pos))
		local rear = get_rear_vector(pos,10)
		local transporter_focus = vector.add(pos,rear)
		local pos1 = vector.add(transporter_focus,{x=-3,y=0,z=-3})
		local pos2 = vector.add(transporter_focus,{x=3,y=0,z=3})
		local pads = core.find_nodes_in_area(pos1,pos2,{"stnodes:transporter_pad","stnodes:transporter_pad_active"})
		local transporters = core.deserialize(storage:get_string("stnodes:transporters"))
		if transporters == nil then
			transporters = {}
		end
		if fields.transporter_id == nil or fields.transporter_id == "" then
			return
		end
		if fields.transporter_id and fields.transporter_id ~= "" then
			local me = player:get_player_name()
			if transporters[fields.transporter_id] == nil then
				transporters[fields.transporter_id] = {}
			end
			transporters[fields.transporter_id].name = fields.transporter_id
			transporters[fields.transporter_id].pos = pos
			meta:set_string("stnodes:transporter_id", fields.transporter_id)
			rhs_meta:set_string("stnodes:transporter_id", fields.transporter_id)
			core.log("info","[stnodes] Setting Transporter ID: "..
			fields.transporter_id..
			" at ("..pos.x..", "..pos.y..", "..pos.z..")")
			meta:set_string("infotext","Transporter: "..fields.transporter_id.."\n"..
			"Owner: "..owner)
		end
		if fields.enable then
			transporters[fields.transporter_id].enabled = true
			core.swap_node(transporter_focus,{ name="stnodes:transporter_focus_active" })
			transporters[fields.transporter_id].pads = {}
			for idx,pad in ipairs(pads) do
				core.swap_node(pad,{ name="stnodes:transporter_pad_active"})
				transporters[fields.transporter_id].pads[idx] = {}
				transporters[fields.transporter_id].pads[idx].pos = pad
			end
			if #transporters[fields.transporter_id].pads > 0 then
				transporters[fields.transporter_id].pads[1].next = true
			end
		elseif fields.disable then
			transporters[fields.transporter_id].enabled = false
			transporters[fields.transporter_id].pads = {}
			core.swap_node(transporter_focus,{ name="air"})
			for _,pad in ipairs(pads) do
				core.swap_node(pad,{ name="stnodes:transporter_pad"})
			end
		end
		storage:set_string("stnodes:transporters",core.serialize(transporters))
	end,
	on_destruct = function(pos)
		local meta = core.get_meta(pos)
		local id = meta:get_string("stnodes:transporter_id")
		if id ~= nil and id ~= "" then
			local rear = get_rear_vector(pos,10)
			local transporter_focus = vector.add(pos,rear)
			local pos1 = vector.add(transporter_focus,{x=-3,y=0,z=-3})
			local pos2 = vector.add(transporter_focus,{x=3,y=0,z=3})
			local pads = core.find_nodes_in_area(pos1,pos2,{"stnodes:transporter_pad","stnodes:transporter_pad_active"})
			local transporters = core.deserialize(storage:get_string("stnodes:transporters"))
			if transporters == nil then
				transporters = {}
			end
			if transporters[id] == nil then
				transporters[id] = {}
			end
			transporters[id].enabled = false
			transporters[id].pads = {}
			core.swap_node(transporter_focus,{ name="air"})
			for _,pad in ipairs(pads) do
				core.swap_node(pad,{ name="stnodes:transporter_pad"})
			end
			storage:set_string("stnodes:transporters",core.serialize(transporters))
		end
		local right = get_pos_to_right(pos)
		local rightnode = core.get_node(right)
		if rightnode.name == "stnodes:transporter_console_r" then
			core.swap_node(right,{ name = "air" })
		end
	end

})
core.register_node("stnodes:transporter_console_r",{
	description = "Transporter Console Right",
	tiles = {
		"transporter_console_top_r.png",
		"duranium.png",
	},
	groups = { cracky = 1, not_in_creative_inventory = 1 },
	drawtype = "nodebox",
	paramtype = "light",
	paramtype2 = "facedir",
	node_box = console_r_nodebox,
	light_source = 4,
	on_receive_fields = function(pos, formname, fields, player)
		local meta = core.get_meta(pos)
		local id = meta:get_string("stnodes:transporter_id")
		if fields.transport_to_player and fields.player then
			local to_player = core.get_player_by_name(fields.player)
			if to_player ~= nil then
				local new_pos = to_player:get_pos()
				local look_dir = to_player:get_look_horizontal()
				if look_dir > 5.49 or look_dir <= 0.79 then
					-- looking +z
					new_pos.z = new_pos.z + 6
				elseif look_dir > 0.79 and look_dir <= 2.36 then
					-- looking -x
					new_pos.x = new_pos.x - 6
				elseif look_dir > 2.36 and look_dir <= 3.93 then
					-- looking -z
					new_pos.z = new_pos.z - 6
				elseif look_dir > 3.93 and look_dir <= 5.49 then
					-- look_dir > 4.5 and look_dir <= 6
					-- looking +x
					new_pos.x = new_pos.x + 6
				end
				new_pos.y = find_safe_height(new_pos)
				local my_name = player:get_player_name()
				core.chat_send_player(my_name,
				"Attempting Transport to "..fields.transport_to_player..
				"in 5 seconds")
				core.after(5, function()
					core.chat_send_player(fields.player,
					"Incoming Transport to your location is being attempted...")
					pad_transport_to(id,new_pos)
				end)
			else
				core.chat_send_player(player:get_player_name(),"No Player Found: ".. fields.player)
			end
		elseif tonumber(fields.xpos) and
			tonumber(fields.ypos) and
			tonumber(fields.zpos) then
			local new_pos = {
				x = tonumber(fields.xpos),
				y = tonumber(fields.ypos),
				z = tonumber(fields.zpos)
			}
			meta:set_int("stnodes_last_xpos",new_pos.x)
			meta:set_int("stnodes_last_ypos",new_pos.y)
			meta:set_int("stnodes_last_zpos",new_pos.z)
			if fields.check_pos then
				local nodes = get_nodes_at_pos(new_pos)
				if nodes ~= nil then
					core.chat_send_player(player:get_player_name(),
					"Node at Position is: "..nodes.at.name.."\n"..
					"Node above Position is: ".. nodes.above.name.."\n"..
					"Node under Position is: ".. nodes.below.name)
				else
					core.chat_send_player(player:get_player_name(),
					"Scanning Transport Area...\n"..
					"Please check again shortly")
				end
			elseif fields.transport_to_pos then
				local nodes = get_nodes_at_pos(new_pos)
				if nodes ~= nil then
					if id ~= nil and id ~= "" then
						core.chat_send_player(player:get_player_name(), "Beaming to...("..new_pos.x..", "..new_pos.y..", "..new_pos.z..")")
						core.chat_send_player(player:get_player_name(),
						"Attempting Transport in 5 seconds")
						core.after(5, function()
							pad_transport_to(id,new_pos)
						end)
					else
						core.chat_send_player(player:get_player_name(),
						"Error in Transport. Failed to find ship")
					end
				else
					core.chat_send_player(player:get_player_name(),
					"Temporary Error in Transport. The destination may not have been emerged. Please try again.")
				end
			end

		end

	end
})

core.register_node("stnodes:transporter_focus_active",{
	description = "Transporter Focus Active",
	tiles = {
		"transporter_focus_active.png"
	},
	groups = { not_in_creative_inventory = 1 },
	drawtype = "airlike",
	paramtype = "light",
	paramtype2 = "facedir",
	pointable = false,
	node_box = transporter_pad_nodebox,
	light_source = core.LIGHT_MAX
})

