
communicate = {}

function communicate.get_formspec(name)
    local text = "Select Ship"
    local ships = get_ship_names()
    if ships ~= nil then
        local avail_ships = table.concat(ships,",")

        local formspec = {
            "formspec_version[4]",
            "size[12,6]",
            "label[0.5,0.5;",core.formspec_escape(text),"]",
            "textlist[0.5,1;4,4;ship_idx;",avail_ships,"]",
            "field[7,2;2,1;to_beam_up;To Beam Up;1]",
            "button_exit[9,2;2,1;transport;Beam Up]",
            "button_exit[9,4;2,1;exit;Exit]",
        }
        return table.concat(formspec,"")
    else
        core.chat_send_player(name, "No Ships Available")
    end
end

function communicate.show_to(name)
    core.show_formspec(name, "stnodes:communication", communicate.get_formspec(name))
end

function is_near_pos(pl_pos, pos)
    local from = { x=pos.x-5, y=pos.y-5, z=pos.z-5}
    local to = { x=pos.x+5, y=pos.y+5, z=pos.z+5}
    if pl_pos.x > from.x and pl_pos.x < to.x and
        pl_pos.y > from.y and pl_pos.y < to.y and
        pl_pos.z > from.z and pl_pos.z < to.z then
        return true
    end
end

function find_players_near_to(player)
    local my_pos = player:get_pos()
    local nearest = {}
    for _,player in pairs(core.get_connected_players()) do
        local pl_pos = player:get_pos()
        if is_near_pos(pl_pos,my_pos) then
            table.insert(nearest,player)
        end
    end
    return nearest
end

core.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "stnodes:communication" then
        return
    end
    if fields.exit then
        return
    elseif fields.ship_idx then
        local textitem = core.explode_textlist_event(fields.ship_idx)
        local ships = get_ship_names()
        local selected_ship = ships[textitem.index]
        if textitem.type == "CHG" then
            local meta = player:get_meta()
            meta:set_string("stnodes:last_ship",selected_ship)
        elseif textitem.type == "DCL" then
            transport(player, selected_ship)
            core.close_formspec(player:get_player_name(),"stnodes:communication")
        end
    elseif fields.transport then
        local meta = player:get_meta()
        local selected_ship = meta:get_string("stnodes:last_ship")
        if selected_ship ~= nil then
            transport(player, selected_ship)
            if tonumber(fields.to_beam_up) then
                local num = tonumber(fields.to_beam_up) - 1
                local players = find_players_near_to(player)
                if num > 0 then
                    for _,pl in ipairs(players) do
                        transport(pl,selected_ship)
                        num = num - 1
                        if num == 0 then
                            break
                        end
                    end
                end
            end
        end
    else
        return
    end
end)

core.register_tool("stnodes:communicator",{
    description = "Communicator",
    inventory_image = "communicator.png",
    wield_scale = 2,
    on_use = function(itemstack, user, pointed_thing)
        communicate.show_to(user:get_player_name())
    end
})
