function get_rear_vector(pos,distance)
    local dist = 1
    if distance ~= nil then
        dist = distance
    end
    local node = core.get_node(pos)
    local dir = node.param2
    local vec = { x = 0, y = 0, z = dist }
    if dir == 2 then
        vec = { x = 0, y = 0, z = -dist }
    elseif dir == 1 then
        vec = { x = dist, y = 0, z = 0}
    elseif dir == 3 then
        vec = { x = -dist, y = 0, z = 0}
    end
    return vec
end
function get_pos_to_right(pos)
    local node = core.get_node(pos)
    local dir = node.param2
    local vec = { x = 1, y = 0, z = 0 }
    if dir == 2 then
        vec = { x = -1, y = 0, z = 0 }
    elseif dir == 1 then
        vec = { x = 0, y = 0, z = -1}
    elseif dir == 3 then
        vec = { x = 0, y = 0, z = 1}
    end
    local right = vector.add(pos,vec)
    return right
end

function get_pos_to_left(pos)
    local node = core.get_node(pos)
    local dir = node.param2
    local vec = { x = -1, y = 0, z = 0 }
    if dir == 2 then
        vec = { x = 1, y = 0, z = 0 }
    elseif dir == 1 then
        vec = { x = 0, y = 0, z = 1}
    elseif dir == 3 then
        vec = { x = 0, y = 0, z = -1}
    end
    local right = vector.add(pos,vec)
    return right
end
local function emerge_callback(pos, action,
        num_calls_remaining, context)
    -- On first call, record number of blocks
    if not context.total_blocks then
        context.total_blocks  = num_calls_remaining + 1
        context.loaded_blocks = 0
    end

    -- Increment number of blocks loaded
    context.loaded_blocks = context.loaded_blocks + 1

    -- Send progress message
    if context.total_blocks == context.loaded_blocks then
        core.log("info","[stnodes] Finished loading blocks around transport area")
    else
        local perc = 100 * context.loaded_blocks / context.total_blocks
        local msg  = string.format("Loading blocks %d/%d (%.2f%%)",
                context.loaded_blocks, context.total_blocks, perc)
        core.log("info",msg)
    end
end
function emerge_around(pos, dist)
    if dist == nil then
        dist = 10
    end
    --local halfsize = { x = dist / 2, y = dist / 2, z = dist / 2 }
    local rng = 5
    local pos1 = { x = pos.x - rng, y = pos.y - rng, z = pos.z - rng }
    --vector.subtract(pos, halfsize)
    local pos2 = { x = pos.x + rng, y = pos.y + rng, z = pos.z + rng }
    --vector.add(pos, halfsize)
    local context = {} -- persist data between callback calls
    core.emerge_area(pos1, pos2, emerge_callback, context)
end
