-- Load support for translation.
local S = minetest.get_translator("brickwalls")

-- table with {wall_name, wall_desc, wall_mat} for all brick walls added;
-- wall_texture_table and wall_sounds will be determined via wall_mat
brickwalls = {
    -- default
    {"brickwalls:brick", "Brick Wall", "default:brick"},
    {"brickwalls:stonebrick", "Stone Brick Wall", "default:stonebrick"},
    {"brickwalls:desert_stonebrick", "Desert Stone Brick Wall", "default:desert_stonebrick"},
    {"brickwalls:sandstonebrick", "Sandstone Brick Wall", "default:sandstonebrick"},
    {"brickwalls:desert_sandstone_brick", "Desert Sandstone Brick Wall", "default:desert_sandstone_brick"},
    {"brickwalls:silver_sandstone_brick", "Silver Sandstone Brick Wall", "default:silver_sandstone_brick"},
    {"brickwalls:obsidianbrick", "Obsidian Brick Wall", "default:obsidianbrick"},
    -- nether
    {"brickwalls:netherbrick", "Nether Brick Wall", "nether:brick"},
    {"brickwalls:netherbrick_compressed", "Compressed Nether Brick Wall", "nether:brick_compressed"},
    {"brickwalls:netherbrick_cracked", "Cracked Nether Brick Wall", "nether:brick_cracked"},
    {"brickwalls:netherbrick_deep", "Deep Nether Brick Wall", "nether:brick_deep"},
    -- ethereal
    {"brickwalls:icebrick", "Ice Brick Wall", "ethereal:icebrick"},
    {"brickwalls:snowbrick", "Snow Brick Wall", "ethereal:snowbrick"},
    -- xdecor
    {"brickwalls:cactusbrick", "Cactus Brick Wall", "xdecor:cactusbrick"},
    {"brickwalls:moonbrick", "Moon Brick Wall", "xdecor:moonbrick"},
    -- sumpf
    {"brickwalls:junglestonebrick", "Swamp Stone Brick Wall", "sumpf:junglestonebrick"},
}

for _, i in pairs(brickwalls) do
    if minetest.registered_nodes[i[3]] then

        -- register walls
        walls.register(i[1], S(i[2]), minetest.registered_nodes[i[3]].tiles,
                        i[3], minetest.registered_nodes[i[3]].sounds)

        -- change groups
        local groups = {}
        for k, v in pairs(minetest.registered_nodes[i[3]].groups) do
            groups[k] = v
        end
        groups.wall = 1
        minetest.override_item(i[1], {groups = groups})
    end
end

-- add more nodes that walls should connect to
for n, def in pairs(minetest.registered_nodes) do
    if def.groups.wall == 1 then
        local connects_to = {
            -- standard groups walls connect to
            "group:wall", "group:stone", "group:fence", "group:wall_connected",
            -- default
            "default:sandstone", "default:sandstonebrick", "default:sandstone_block",
            "default:desert_sandstone", "default:desert_sandstone_brick", "default:desert_sandstone_block",
            "default:silver_sandstone", "default:silver_sandstone_brick", "default:silver_sandstone_block",
            "default:obsidian", "default:obsidianbrick", "default:obsidian_block",
            "default:ice",
            "default:brick",
            -- nether
            "nether:rack", "nether:rack_deep",
            "nether:brick", "nether:brick_compressed", "nether:brick_cracked", "nether:brick_deep",
            --"nether:fence_nether_brick",
            -- ethereal
            "ethereal:icebrick", "ethereal:snowbrick",
            -- xdecor
            "xdecor:cactusbrick", "xdecor:moonbrick",
            -- sumpf
            "sumpf:junglestone", "sumpf:cobble", "sumpf:junglestonebrick",
        }

        -- add panes depending on settings
        if minetest.get_modpath("xpanes") and minetest.settings:get_bool("connect_xpanes", true) then
            table.insert(connects_to, "group:pane")
        end

        minetest.override_item(n, {connects_to = connects_to})

    -- we also need to add walls to 'connects_to' of panes
    elseif minetest.get_modpath("xpanes") and minetest.settings:get_bool("connect_xpanes", true) and def.groups.pane == 1 and def.connects_to then
        local connects_to = def.connects_to
        table.insert(connects_to, "group:wall")

        minetest.override_item(n, {connects_to = connects_to})
    end
end