local regrowing_apples = minetest.settings:get_bool("regrowing_apples", true)

local add_fruit_regrowable = function(fruit, node, leaves)

	-- override fruit
	minetest.override_item(node, {
		after_dig_node = function(pos, oldnode, oldmetadata, digger)
			if oldnode.param2 == 0 then
				minetest.set_node(pos, {name = "regrowing_fruits:"..fruit.."_mark"})
				minetest.get_node_timer(pos):start(math.random(300, 1500))
			end
		end,
	})

	-- air node to mark fruit pos
	minetest.register_node("regrowing_fruits:"..fruit.."_mark", {
		description = "Air!",
		drawtype = "airlike",
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		pointable = false,
		diggable = false,
		buildable_to = true,
		drop = "",
		groups = {not_in_creative_inventory = 1},
		on_timer = function(pos, elapsed)
			if not minetest.find_node_near(pos, 1, leaves) then
				minetest.remove_node(pos)
			elseif minetest.get_node_light(pos) < 13 then
				minetest.get_node_timer(pos):start(200)
			else
				minetest.set_node(pos, {name = node})
			end
		end
	})
end

if regrowing_apples then
	add_fruit_regrowable("apple", "default:apple", "default:leaves")
end

if minetest.get_modpath("ethereal") then
	add_fruit_regrowable("banana","ethereal:banana", "ethereal:bananaleaves")
	add_fruit_regrowable("coconut", "ethereal:coconut", "ethereal:palmleaves")
	add_fruit_regrowable("goldapple", "ethereal:golden_apple", "ethereal:yellowleaves")
	add_fruit_regrowable("orange", "ethereal:orange", "ethereal:orange_leaves")
end