local gs_update_interval = 1
local gs_timer = 0

boss_s_hudbar = {}
local bosses_names = {}

local hud_boss = {} 
local hud_boss_name = {}

function boss_s_hudbar.add_boss(boss_id, boss_tag, hudbar_size,hudbar_texture)
    table.insert(bosses_names, {
        name = boss_id,
        tag = boss_tag,
        bar_size = hudbar_size,
        bar_texture = hudbar_texture
    })
end

-- ATUALIZAR HUD CASO O PLAYER ESTEJA PROXIMO AO BOSS : ============================
local function hudbar_bosses_update()
    local players = core.get_connected_players()
    
    for _, player in ipairs(players) do
        local pos = player:get_pos()
        local pname = player:get_player_name()
        local found = false
        
        for _, obj in pairs(core.get_objects_inside_radius(pos,15)) do
            for _, boss in pairs(bosses_names) do
                local v_entity = obj:get_luaentity()
                
                if v_entity and v_entity.name == boss.name then
                    found = true
                    local health = v_entity.health

                    if hud_boss[pname] then
                        player:hud_change(hud_boss[pname], "number", health)
                    else
                        local size_max = 1500 / health                         
                        hud_boss[pname] = player:hud_add({
                            hud_elem_type = "statbar",
                            position = {x=0.3, y=0},
                            direction = 0,
                            offset = {x=50, y=50},
                            size = {x=size_max, y=30},    
                            text = boss.bar_texture..".png",
                            number = health,
                            text2 = boss.bar_texture.."_bg.png",
                            item = boss.bar_size,
                            name = "boss_health" ,
                            max = 0,
                        })                                                                    
                   end  

                    if hud_boss_name[pname] then
                        player:hud_change(hud_boss_name[pname], "text",boss.tag)
                    else
                        hud_boss_name[pname] = player:hud_add({
                            hud_elem_type = "text",
                            scale = {x=100, y=100},
                            text = boss.tag,
                            number = "0xFFFFFF",          
                            offset  = {x = 1000, y = 20},
                            size = {x=1.5, y=1.5},
                            style = 1 ,
                            name = "hud_boss_name",
                        })
                    end
                end
            end
        end

        if not found then
            if hud_boss[pname] then
                player:hud_remove(hud_boss[pname])
                hud_boss[pname] = nil
            end
            
            if hud_boss_name[pname] then
                player:hud_remove(hud_boss_name[pname])
                hud_boss_name[pname] = nil
            end
        end
    end
end

local gs_timer = 0
local gs_update_interval = 1 

core.register_globalstep(function(dtime)
    gs_timer = gs_timer + dtime
    
    if gs_timer >= gs_update_interval then
        hudbar_bosses_update()        
        gs_timer = 0
    end
end)

---- ADICIONAR BOSSES : ==========================================================================
-- NSSM BOSSES
boss_s_hudbar.add_boss("nssm:giant_sandworm", "Giant Sandworm Boss", 330, "boss_bar_brown")
boss_s_hudbar.add_boss("nssm:kraken", "Kraken Boss", 350, "boss_bar_pink")
boss_s_hudbar.add_boss("nssm:echidna", "Echidna Boss", 240, "boss_bar_green")
boss_s_hudbar.add_boss("nssm:phoenix", "Phoenix Boss", 160, "boss_bar_orange")

boss_s_hudbar.add_boss("nssm:ant_queen", "Ant Queen Boss", 220, "boss_bar_brown")
boss_s_hudbar.add_boss("nssm:lava_titan", "Lava Titan Boss", 240, "boss_bar_orange")
boss_s_hudbar.add_boss("nssm:mese_dragon", "Mese Dragon Boss", 666, "boss_bar_yellow")

boss_s_hudbar.add_boss("nssm:duckking", "Duckking Boss", 180, "boss_bar")
boss_s_hudbar.add_boss("nssm:icelamander", "Ice Lamander Boss", 240, "boss_bar_blue")
boss_s_hudbar.add_boss("nssm:pumpking", "Mese Dragon Boss", 220, "boss_bar_orange")
-- DMOBS BOSSES
boss_s_hudbar.add_boss("dmobs:dragon_great", "Boss Dragon", 250, "boss_bar")
boss_s_hudbar.add_boss("dmobs:waterdragon", "Water Dragon Boss", 127, "boss_bar_blue")
boss_s_hudbar.add_boss("dmobs:wyvern", "Wyvern Boss", 150, "boss_bar_yellow")
-- LIVING NETHER BOSS
boss_s_hudbar.add_boss("livingnether:noodlemaster", "Nood Lemaster", 1000, "boss_bar")
-- BALROG BOSS 
boss_s_hudbar.add_boss("mobs_balrog:balrog", "Balrog", 1000, "boss_bar_orange")
boss_s_hudbar.add_boss("lottmobs:balrog", "Balrog", 1000, "boss_bar_orange")
-- NETHER MOBS 
boss_s_hudbar.add_boss("nether_mobs:dragon", "Nether Dragon", 300, "boss_bar_purple")

