local gs_update_interval = 1
local gs_timer = 0

boss_s_hudbar = {}
local bosses_names = {}

local hud_boss = {} 
local hud_boss_name = {}

function boss_s_hudbar.add_boss(boss_id, boss_tag, hudbar_size,hudbar_texture,hudbar_adj)
    table.insert(bosses_names, {
        name = boss_id,
        tag = boss_tag,
        bar_size = hudbar_size,
        bar_texture = hudbar_texture,
        bar_adj = hudbar_adj,
    })
end

-- ATUALIZAR HUD CASO O PLAYER ESTEJA PROXIMO AO BOSS : ============================
local function hudbar_bosses_update()
    local players = core.get_connected_players()
    
    for _, player in ipairs(players) do
        local pos = player:get_pos()
        local pname = player:get_player_name()
        local found = false
        
        for _, obj in pairs(core.get_objects_inside_radius(pos,15)) do
            for _, boss in pairs(bosses_names) do
                local v_entity = obj:get_luaentity()
                
                if v_entity and v_entity.name == boss.name then
                    found = true
                    local health = v_entity.health
                          health_bar = health / boss.bar_adj

                    if hud_boss[pname] then
                        player:hud_change(hud_boss[pname], "number", health_bar)
                    else
                                            
                        hud_boss[pname] = player:hud_add({
                            hud_elem_type = "statbar",
                            position = {x=0.33, y=0},
		            direction = 0,
		            offset = {x=50, y=50},
		            size = {x= 1, y=15},    
                            text = boss.bar_texture..".png",
                            number = health_bar,
                            text2 = boss.bar_texture.."_bg.png",
                            item = boss.bar_size,
                            name = "boss_health" ,
                            max = 0,
                        })                                                                    
                   end  

                    if hud_boss_name[pname] then
                        player:hud_change(hud_boss_name[pname], "text",boss.tag)
                    else
                        hud_boss_name[pname] = player:hud_add({
                            hud_elem_type = "text",
                            position = {x=0.46, y=0.03},
			    offset = {x=50, y=50},
			    scale = {x=0.5, y=0.5},
                            text = boss.tag,
                            number = "0xFFFFFF",          
                            size = {x = 1.0},
                            style = 1 ,
                            name = "hud_boss_name",
                        })
                    end
                end
            end
        end

        if not found then
            if hud_boss[pname] then
                player:hud_remove(hud_boss[pname])
                hud_boss[pname] = nil
            end
            
            if hud_boss_name[pname] then
                player:hud_remove(hud_boss_name[pname])
                hud_boss_name[pname] = nil
            end
        end
    end
end

local gs_timer = 0
local gs_update_interval = 1 

core.register_globalstep(function(dtime)
    gs_timer = gs_timer + dtime
    
    if gs_timer >= gs_update_interval then
        hudbar_bosses_update()        
        gs_timer = 0
    end
end)

---- ADICIONAR BOSSES : ==========================================================================
-- NSSM BOSSES
boss_s_hudbar.add_boss("nssm:giant_sandworm", "Giant Sandworm Boss", 1000, "boss_bar_brown",0.33)
boss_s_hudbar.add_boss("nssm:kraken", "Kraken Boss", 1000, "boss_bar_pink",0.35)
boss_s_hudbar.add_boss("nssm:echidna", "Echidna Boss", 1000, "boss_bar_green",0.24)
boss_s_hudbar.add_boss("nssm:phoenix", "Phoenix Boss", 1000, "boss_bar_orange",0.16)

boss_s_hudbar.add_boss("nssm:ant_queen", "Ant Queen Boss", 1000, "boss_bar_brown",0.2)
boss_s_hudbar.add_boss("nssm:lava_titan", "Lava Titan Boss", 1000, "boss_bar_orange",0.18)
boss_s_hudbar.add_boss("nssm:mese_dragon", "Mese Dragon Boss", 1000, "boss_bar_yellow",0.66)

boss_s_hudbar.add_boss("nssm:duckking", "Duckking Boss", 1000, "boss_bar",0.18)
boss_s_hudbar.add_boss("nssm:icelamander", "Ice Lamander Boss", 1000, "boss_bar_blue",0.24)
boss_s_hudbar.add_boss("nssm:pumpking", "Mese Dragon Boss", 1000, "boss_bar_orange",0.2)
-- DMOBS BOSSES
boss_s_hudbar.add_boss("dmobs:dragon_great", "Boss Dragon", 1000, "boss_bar",0.22)
boss_s_hudbar.add_boss("dmobs:waterdragon", "Water Dragon Boss", 1000, "boss_bar_blue",0.12)
boss_s_hudbar.add_boss("dmobs:wyvern", "Wyvern Boss", 1000, "boss_bar_yellow",0.15)
-- LIVING NETHER BOSS
boss_s_hudbar.add_boss("livingnether:noodlemaster", "Nood Lemaster", 1000, "boss_bar",1)
-- BALROG BOSS 
boss_s_hudbar.add_boss("mobs_balrog:balrog", "Balrog", 1000, "boss_bar_orange",1)
boss_s_hudbar.add_boss("lottmobs:balrog", "Balrog", 1000, "boss_bar_orange",1)
-- NETHER MOBS 
boss_s_hudbar.add_boss("nether_mobs:dragon", "Nether Dragon", 1000, "boss_bar_purple",0.3)

