local itens_name = {}
local last_item_name = {}
local timers = {}

btmt.wielded_item_name = core.settings:get_bool("wielded_item_name", true)

if btmt.wielded_item_name then 

local function wi_hud(player)
    local player_name = player:get_player_name()
    itens_name[player_name] = player:hud_add({
        hud_elem_type = "text",
        position = {x=0.5, y=0.87},
        text = "",
        number = 0xFFFFFF,
    })
end

local function wi_hud_update(player, dtime)
    local player_name = player:get_player_name()
    local p_hud = itens_name[player_name]
    if not p_hud then return end

    local item = player:get_wielded_item():get_name()
    if last_item_name[player_name] ~= item then
        last_item_name[player_name] = item
        local def = minetest.registered_items[item]
        local text = def and def.description or ""
        player:hud_change(p_hud, "text", text)
        timers[player_name] = 0
    end

    if timers[player_name] then
        timers[player_name] = timers[player_name] + dtime
        if timers[player_name] >= 2 then
            player:hud_change(p_hud, "text", "")
            timers[player_name] = nil
        end
    end
end

minetest.register_on_joinplayer(function(player)
    wi_hud(player)
end)

minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
        wi_hud_update(player, dtime)
    end
end)

end

