farming.register_plant("btmt:pumpkin", {
	description = "Pumpkin",
	harvest_description = "pumpkin",
	paramtype = "light",
	paramtype2 = "plantlike",  
	inventory_image = "pumpkin_seed.png",
	steps = 8, 
	minlight = 13,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland"},
	groups = {flammable = 4,not_in_creative_inventory = 1},
	place_param2 = 3,
	drop = "",		
})

core.register_node("btmt:pumpkin_8", {
	description = "Pumpkin",
	--inventory_image = "pumpkin.png",
	tiles = {
		"farming_pumpkin_bottom.png^farming_pumpkin_top.png",
		"farming_pumpkin_bottom.png",
		"farming_pumpkin_side.png"
	},
	groups = {choppy = 1, oddly_breakable_by_hand = 3,flammable = 2, crops = 1},
	drop = "btmt:pumpkin_8",
	sounds = default.node_sound_wood_defaults(),
	paramtype2 = "facedir",
	on_place = core.rotate_node
})


core.register_craftitem("btmt:pumpkin_slice", {
	description = "Pumpkin Slice",
	inventory_image = "farming_pumpkin_slice.png",
	on_use = core.item_eat(1)
})

core.register_craft({ 
    type = "shapeless",
    output = "btmt:pumpkin_slice 4",
    recipe = {
        "btmt:pumpkin_8",
    },
})

core.register_craft({
    type = "shapeless",
    output = "btmt:seed_pumpkin 1",
    recipe = {
        "btmt:pumpkin_slice",
    },
})

core.register_decoration({
	name = "btmt:pumpkin_8_dec",
	deco_type = "simple",
	place_on = {"default:dry_dirt_with_dry_grass"},
	sidelen = 16,
	fill_ratio = 0.005,	
	biomes = {"savanna"},
	spawn_by = {"default:dry_grass_1","default:dry_grass_3","default:acacia_tree"},
        num_spawn_by = 2,
	
	y_min = 1,
	y_max = 31000,
	decoration = "btmt:pumpkin_8",
})
