minetest.register_craftitem("btmt:egg", {
	description = "Fried Egg",
	inventory_image = "mobs_chicken_egg.png",
})

mobs:register_mob("btmt:chicken", {
	stepheight = 0.6,
	type = "animal",
	passive = true,
	hp_min = 5,
	hp_max = 10,
	armor = 200,
	collisionbox = {-0.3, -0, -0.3, 0.3, 0.5, 0.3},
	visual = "mesh",
	mesh = "btmt_chiken.glb",
	visual_size = {x = 10, y = 10},
	textures = {
		{"btmt_chiken.png"}, 
		--{"btmt_chiken.png"},
		--{"btmt_chiken.png"}
	},
	child_texture = {
		{"btmt_chiken_baby.png"}
	},
	makes_footstep_sound = true,
	sounds = {
		random = "mobs_chicken"
	},
	walk_velocity = 1,
	run_velocity = 3,
	--runaway = true,
	--runaway_from = {"player", "btmt:pumba"},
	drops = {
		{name = "mobs:chicken_raw", chance = 1, min = 1, max = 1},
		{name = "mobs:chicken_feather", chance = 1, min = 0, max = 2}
	},
	water_damage = 1,
	lava_damage = 5,
	light_damage = 0,
	fall_damage = 0,
	fall_speed = -4,
	fear_height = 5,
	animation = {
		speed_normal = 10,
		stand_speed = 10,
		stand1_speed = 20,
		run_start = 40,
		stand_start = 1,
		stand_end = 20,
		stand1_start = 60,
		stand1_end = 72,
		walk_start = 24,
		walk_end = 36,
		walk_speed = 10,
		run_end = 52,
		run_speed = 24,
		--die_start = 104,
		--die_end = 117, 
		--die_speed = 15,
	},
	follow = {"farming:seed_wheat"},
	view_range = 5,

	on_rightclick = function(self, clicker)

		if mobs:feed_tame(self, clicker, 8, true, true) then return end
		if mobs:protect(self, clicker) then return end
		if mobs:capture_mob(self, clicker, 30, 50, 80, false, nil) then return end
	end,

	do_custom = function(self, dtime)

		self.egg_timer = (self.egg_timer or 0) + dtime
		if self.egg_timer < 1 then
			return
		end
		self.egg_timer = 0

		if self.child
		or math.random(100) > 1 then
			return
		end

		local pos = self.object:get_pos() ; if not pos then return end
		pos.y = pos.y - 1
		local node = minetest.get_node_or_nil(pos)
		if node and node.name ~= "air" and minetest.get_item_group(node.name, "soil") > 0 then
		    minetest.add_item(pos,"btmt:egg")
		end
	end
})

mobs:spawn({
 name = "btmt:chicken",
 nodes = "default:dirt_with_grass",
 neighbors = {"group:grass"},
 min_light = 14,
 interval = 60,
 chance = 4000,
 active_object_count = 3,
 min_height = 5,
 max_height = 200,
 day_toggle = true
})

mobs:register_egg("btmt:chicken", "Chicken", "btmt_chicken_inv.png", 0)

-- fried egg
minetest.register_craftitem("btmt:chicken_egg_fried", {
	description = "Fried Egg",
	inventory_image = "mobs_chicken_egg_fried.png",
	on_use = minetest.item_eat(2),
	groups = {food_egg_fried = 1, flammable = 2}
})

minetest.register_craft({
	type  =  "cooking",
	recipe  = "btmt:egg",
	output = "btmt:chicken_egg_fried"
})

-- raw chicken
minetest.register_craftitem("btmt:chicken_raw", {
	description = "Raw Chicken",
	inventory_image = "mobs_chicken_raw.png",
	on_use = minetest.item_eat(2),
	groups = {food_meat_raw = 1, food_chicken_raw = 1, flammable = 2}
})

-- cooked chicken
minetest.register_craftitem("btmt:chicken_cooked", {
	description = "Cooked Chicken",
	inventory_image = "mobs_chicken_cooked.png",
	on_use = minetest.item_eat(6),
	groups = {food_meat = 1, food_chicken = 1, flammable = 2}
})

minetest.register_craft({
	type  =  "cooking",
	recipe  = "mobs:chicken_raw",
	output = "mobs:chicken_cooked"
})

-- feather
minetest.register_craftitem("btmt:chicken_feather", {
	description = "Feather",
	inventory_image = "mobs_chicken_feather.png",
	groups = {flammable = 2, feather = 1}
})

