-- Cow by sirrobzeroone
-- inspired model : https://encurtador.com.br/CPvb
mobs:register_mob("btmt:cow", {
	type = "animal",
	passive = false,
	attack_type = "dogfight",
	attack_npcs = false,
	reach = 2,
	damage = 4, attack_chance = 98,
	hp_min = 10,
	hp_max = 20,
	armor = 100,
	collisionbox = {-0.4, -0.01, -0.4, 0.4, 1.2, 0.4},
	visual = "mesh",
	mesh = "btmt_cow.glb",
	textures = {
		{"btmt_cow.png"},
		--{"mobs_cow2.png"}
	},
	visual_size = {x = 12, y = 12},
	makes_footstep_sound = true,
	sounds = {
		random = "mobs_cow",
		replace = "default_dig_crumbly"
	},
	walk_velocity = 1,
	run_velocity = 2,
	jump = true,
	jump_height = 6,
	pushable = true,
	drops = {
		{name = "mobs:meat_raw", chance = 1, min = 1, max = 3},
		{name = "mobs:leather", chance = 1, min = 0, max = 2}
	},
	water_damage = 0.01,
	lava_damage = 5,
	light_damage = 0,
	animation = {
		stand_start = 0, stand_end = 20, stand_speed = 10,
		--stand1_start = 35, stand1_end = 75, stand1_speed = 20,
		walk_start = 24, walk_end = 48, walk_speed = 10,
		run_start = 56, run_end = 80, run_speed = 10,
		punch_start = 56, punch_end = 80, punch_speed = 10,
		--die_start = 165, die_end = 185, die_speed = 25, die_loop = false
	},
	follow = {
		"farming:wheat", "default:grass_1", "farming:barley",
		"farming:oat", "farming:rye"
	},
	view_range = 8,
	--replace_rate = 10,
	--replace_what = {"group:grass", "air", 0},
	fear_height = 2,

	on_rightclick = function(self, clicker)

		if mobs:feed_tame(self, clicker, 8, true, true) then

			if self.food and self.food > 6 then self.gotten = false end

			return
		end

		if mobs:protect(self, clicker) then return end
		if mobs:capture_mob(self, clicker, 0, 5, 60, false, nil) then return end

		local tool = clicker:get_wielded_item()
		local name = clicker:get_player_name()
		local item = tool:get_name()

		-- milk cow with empty bucket
		if item == "bucket:bucket_empty"
		or item == "wooden_bucket:bucket_wood_empty"
		or item == "bucket_wooden:bucket_empty" then

			if self.child == true then return end

			if self.gotten == true then

				core.chat_send_player(name, "Cow already milked!")

				return
			end

			local inv = clicker:get_inventory()

			tool:take_item()
			clicker:set_wielded_item(tool)
		
			local ret_item = "mobs:bucket_milk"

			if item == "wooden_bucket:bucket_wood_empty"
			or item == "bucket_wooden:bucket_empty" then
				ret_item = "mobs:wooden_bucket_milk"
			end

			if inv:room_for_item("main", {name = ret_item}) then
				clicker:get_inventory():add_item("main", ret_item)
			else
				local pos = self.object:get_pos()

				pos.y = pos.y + 0.5

				core.add_item(pos, {name = ret_item})
			end

			self.gotten = true -- milked

			return
		end
	end,

	on_replace = function(self, pos, oldnode, newnode)

		self.food = (self.food or 0) + 1

		if self.food >= 8 then 
			self.food = 0
			self.gotten = false
		end
	end
})

if not mobs.custom_spawn_animal then

	mobs:spawn({
		name = "btmt:cow",
		nodes = {"default:dirt_with_grass", "ethereal:green_dirt"},
		neighbors = {"group:grass"},
		min_light = 14,
		interval = 60,
		chance = 8000,
		min_height = 5,
		max_height = 200,
		day_toggle = true
	})
end

core.register_craftitem(":mobs:bucket_milk", {
	description = "Bucket of Milk",
	inventory_image = "mobs_bucket_milk.png",
	stack_max = 1,
	on_use = core.item_eat(8, "bucket:bucket_empty"),
	groups = {food_milk = 1, drink = 1}
})

mobs:register_egg("btmt:cow", "Cow", "btmt_cow_inv.png")


