mobs:register_mob("btmt:cric", {
	type = "monster",
	passive = false,
	damage = 15,
	attack_type = "shoot",
	shoot_interval = 0.5,
	arrow = "btmt:cric_arrow",
	shoot_offset = 2,
	hp_min = 50,
	hp_max = 50,
	armor = 80,
	collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
	visual = "mesh",
	mesh = "ico_monster.b3d",
	textures = {{"ice_monster.png"}},
	blood_texture = "default_ice.png",
	makes_footstep_sound = false,
	sounds = {random = "mobs_mesemonster"},
	view_range = 10,
	walk_velocity = 0.5,
	run_velocity = 2,
	jump = true,
	jump_height = 8,
	fall_damage = 0,
	fall_speed = -6,
	stepheight = 2.1,
	drops = {
		{name = "default:ice", chance = 1, min = 1, max = 5},
		{name = "default:snow", chance = 5, min = 1, max = 3},
	},
	water_damage = 1,
	lava_damage = 1,
	light_damage = 0,
	animation = {
		speed_normal = 15, speed_run = 15,
		stand_start = 0, stand_end = 20,
		walk_start = 1, walk_end = 20,
		run_start = 1, run_end = 20,
		punch_start = 1, punch_end = 20,
	},

	arrow_override = function(self)
		self.velocity = 6
		self.damage = 5
	end
})


mobs:register_arrow("btmt:cric_arrow", {
	visual = "cube",
	visual_size = {x = 0.5, y = 0.5},
	textures = {"default_ice.png","default_ice.png","default_ice.png","default_ice.png","default_ice.png","default_ice.png","default_ice.png"},
	velocity = 6,

	hit_player = function(self, player)
	player:punch(self.object, 1.0, {
		full_punch_interval = 1.0,
		damage_groups = {fleshy = 3},
		}, nil)
	end,

	hit_mob = function(self, player)
	end,

	hit_node = function(self, pos, node)
	end
})

mobs:spawn({
	name = "btmt:cric",
	nodes = {"default:snowblock","default:ice"},
	min_light = 0,
	max_light = 14,
	chance = 2000,
	min_height = 0,
	max_height = 200,
	
})

mobs:register_egg("btmt:cric", "Cric","default_ice.png", 1)
