mobs:register_mob("btmt:sheep", {
		type = "animal",
		stay_near = {"farming:straw", 10},
		stepheight = 0.6,
		passive = true,
		hp_min = 8,
		hp_max = 10,
		armor = 200,
		collisionbox = {-0.5, -0.2, -0.5, 0.5, 1.2, 0.5},
		visual = "mesh",
		mesh = "btmt_sheep.glb",
		textures = {
			{"btmt_sheep.png"}
		},
		gotten_texture = {"btmt_sheep_shaved.png"},
		gotten_mesh = "btmt_sheep.glb",
		visual_size = {x = 10, y = 10},
		makes_footstep_sound = true,
		sounds = {
			random = "mobs_sheep"
		},
		walk_velocity = 1,
		run_velocity = 2,
		runaway = true,
		jump = true,
		jump_height = 6,
		pushable = true,
		drops = {
		{name = "mobs:meat", chance = 1, min = 1, max = 2},
		{name = "wool:white", chance = 2, min = 1, max = 1},
	        },
		water_damage = 0.01,
		lava_damage = 5,
		light_damage = 0,
		animation = {
			speed_normal = 10,
			speed_run = 15,
			stand_start = 1,
			stand_end = 20,
			walk_start = 24,
			walk_end = 36,
			--die_start = 110, 
			--die_end = 180, 
			--die_speed = 15, 
			--die_loop = false,
			--die_rotate = true
		},
		follow = {"farming:wheat"},
		view_range = 8,
		replace_rate = 10,
		replace_what = {
			{"group:grass", "air", -1},
			{"default:dirt_with_grass", "default:dirt", -2}
		},
		fear_height = 3,

		on_replace = function(self, pos, oldnode, newnode)

		  self.food = (self.food or 0) + 1
			
		  if self.food >= 8 then

				self.food = 0
				self.gotten = false
				self.drops = drops_normal

				self.object:set_properties({
					textures = {
						"btmt_sheep.png"
					},
					mesh = "btmt_sheep.glb",
				})
			end
		end,

		on_rightclick = function(self, clicker)
	
			if mobs:feed_tame(self, clicker, 8, true, true) then
				if self.food and self.food > 6 then
					self.gotten = false
					self.drops = drops_normal

					self.object:set_properties({
						textures = {
							"btmt_sheep.png"
						},
						mesh = "btmt_sheep.glb"
					})
				end

				return
			end

			local item = clicker:get_wielded_item()
			local itemname = item:get_name()
			local name = clicker:get_player_name()


			if itemname == "mobs:shears" then

			if self.gotten ~= false or self.child ~= false or name ~= self.owner or not minetest.get_modpath("wool") then
			    return
			end

				self.gotten = true 
				self.drops = drops_gotten

				local obj = minetest.add_item(
					self.object:get_pos(),
					ItemStack("wool:white")
				)

				item:add_wear(650) -- 100 uses

				clicker:set_wielded_item(item)

				self.object:set_properties({
					textures = {"btmt_sheep_shaved.png"},
					mesh = "btmt_sheep.glb"
				})

				return
			end
			
			if mobs:protect(self, clicker) then return end
			if mobs:capture_mob(self, clicker, 0, 5, 60, false, nil) then return end
		end
})

	
mobs:register_egg("btmt:sheep", "Sheep", "btmt_sheep_inv.png")

mobs:spawn({
 name = "btmt:sheep",
 nodes = {"default:dirt_with_grass"},
 neighbors = {"group:grass"},
 min_light = 14,
 interval = 60,
 chance = 4000, -- 8000
 active_object_count = 3,
 min_height = 5,
 max_height = 200,
 day_toggle = true
})

