function btmt.lanterns(name, def)
minetest.register_node(name.."_ceiling", {
	description = def.description,
	drawtype = "mesh",
	mesh = def.mesh.."_top.obj",
	tiles = def.tiles,
	use_texture_alpha = "clip",
	--wield_scale = {x=1, y=1, z=1},
	walkable = true,
	groups = {snappy = 3,not_in_creative_inventory=1},
	paramtype = "light",
	paramtype2 = "facedir",
	light_source = 12,
	drop = name,
	node_box = { type = "fixed", fixed =  {{-0.2, -0.1, -0.2, 0.2,0.5, 0.2}}},
	selection_box = {type = "fixed", fixed =   {{-0.2, -0.1, -0.2, 0.2,0.5, 0.2}}},	
})

minetest.register_node(name, {
	description = def.description,
	drawtype = "mesh",
	mesh = def.mesh..".obj",
	tiles = def.tiles,
	use_texture_alpha = "clip",
	--wield_scale = {x=1, y=1, z=1},
	walkable = true,
	groups = {snappy = 3},
	paramtype = "light",
	paramtype2 = "facedir",
	light_source = 12,
	drop = name,
	node_box = {type = "fixed", fixed =  {{-0.2, -0.5, -0.2, 0.2,0.1, 0.2}}},
	selection_box = {type = "fixed", fixed = {{-0.2, -0.5, -0.2, 0.2,0.1, 0.2}}},
	
	on_place = function(itemstack, placer, pointed_thing)
	 if pointed_thing.type ~= "node" then return itemstack end
	 itemstack:set_name(name)
	 local under, above = pointed_thing.under, pointed_thing.above
	 local dy = above.y - under.y
	 local node_name = (dy == 1) and (name) or (dy == -1 and (name.."_ceiling") or (name))
	   if not minetest.registered_nodes[node_name] then return itemstack end
	   local n = minetest.get_node_or_nil(above) or minetest.get_node(above)
	   if not (n.name == "air") then return minetest.item_place_node(itemstack, placer, pointed_thing) end
	    minetest.item_place_node(ItemStack(node_name), placer, pointed_thing)
	      itemstack:take_item(1)
	    return itemstack
         end,
})
end

btmt.lanterns ("btmt:lantern",{
description = "Lantern",
mesh = "dlantern",
tiles = {"dlantern.png"},	
})

core.register_craft({
    type = "shaped",
    output = "btmt:lantern",
    recipe = {
        {"","default:steel_ingot",""},
        {"","default:torch",""},
        {"","default:glass",""}
    }
})
