-- trees
btmt.falling_leaves = core.settings:get_bool("falling_leaves", false)
btmt.dust_in_caves = core.settings:get_bool("dust_in_caves", false)
btmt.snowflakes = core.settings:get_bool("snowflakes", false)
btmt.dust_in_desert = core.settings:get_bool("dust_in_desert", false)
btmt.fire_smoke = core.settings:get_bool("fire_smoke", false)
btmt.breathing_underwater = core.settings:get_bool("breathing_underwater", true)

local particle_texture = {
{leave = "default:leaves" , leaf = "leaf_defaul.png"},
{leave = "default:jungleleaves" , leaf = "leaf_defaul.png"},
{leave = "default:acacia_leaves" , leaf = "leaf_acacia.png"},
{leave = "default:aspen_leaves" , leaf = "leaf_aspen.png"},
}

-- LEAVES:
if btmt.falling_leaves then 
for _,pt in pairs (particle_texture) do
minetest.register_abm({
    nodenames = {pt.leave},
    neighbors = {"air"},
    interval = 15, -- 8
    chance = 30, -- 300
    catch_up = false,
    action = function(pos)
        local below = {x = pos.x, y = pos.y - 1, z = pos.z}
        if minetest.get_node(below).name ~= "air" then return end

        minetest.add_particle({
            pos = {
                x = pos.x + math.random(),
                y = pos.y - 0.3,
                z = pos.z + math.random()
            },
            velocity = {
                x = - 0.3 * math.random(0.1,0.6),
                y = -1,
                z = 0
            },
            acceleration = {x = 0, y = -0.01, z = 0},
            expirationtime = math.random(5,10),
            size = math.random(3,5),
            collisiondetection = true,
            vertical = false,
            texture = pt.leaf,
            glow = 0,
        })
    end,
})
end

end

-- snowflakes
if btmt.snowflakes then 	
minetest.register_abm({
    nodenames = {"default:snow","default:snowblock","default:cave_ice"},
    interval = 2,
    chance = 5,
    catch_up = false,
    action = function(pos)
        for _,player in ipairs(minetest.get_connected_players()) do
            local p = player:get_pos()
            if p.y > -18 and vector.distance(p, pos) < 6 then
                minetest.add_particle({
                    pos = {x=pos.x, y=pos.y + 2, z=pos.z},
                    
                    velocity = {
                    x=(math.random()-0.5)*0.2,
                    y=(math.random()-0.8), 
                    z=(math.random()-0.5)*0.2},
                    
                    acceleration = {x=0, y=0, z=0},
                    expirationtime = 1.5 + math.random(),
                    size = math.random(1.2,2.5),
                    texture = "snowflakes.png",
                    glow = 3,
                })
            end
        end
    end,
})
end

-- Dust in Dsert
if btmt.dust_in_desert then 	
minetest.register_abm({
    nodenames = {"default:desert_sand"},
    interval = 2,
    chance = 10,
    catch_up = false,
    action = function(pos)
        for _,player in ipairs(minetest.get_connected_players()) do
            local p = player:get_pos()
            if p.y > 0 and vector.distance(p, pos) < 6 then
                minetest.add_particle({
                    pos = {x=pos.x, y=pos.y + 2, z=pos.z},
                    
                    velocity = {
                    x=(math.random()-0.5)*2.5,
                    y=(math.random()-0.8), 
                    z=(math.random()-0.5)*2.5},
                    
                    acceleration = {x=0, y=0, z=0},
                    expirationtime = 1.5 + math.random(),
                    size = math.random(0.5,0.9),
                    texture = "dust_desert.png",
                    glow = 0,
                })
            end
        end
    end,
})
end


-- Dust In Caves
if btmt.dust_in_caves then 	
minetest.register_abm({
    nodenames = {"air"},
    interval = 2,
    chance = 15,
    catch_up = false,
    action = function(pos)
        for _,player in ipairs(minetest.get_connected_players()) do
            local p = player:get_pos()
            if p.y < -20 and vector.distance(p, pos) < 6 then
                minetest.add_particle({
                    pos = {x=pos.x, y=pos.y, z=pos.z},
                    
                    velocity = {
                    x=(math.random()-0.5)*0.2,
                    y=(math.random()-0.8), 
                    z=(math.random()-0.5)*0.2},
                    
                    acceleration = {x=0, y=0, z=0},
                    expirationtime = 1.5 + math.random(),
                    size = math.random(0.2,0.5),
                    texture = "dust_caves.png",
                    glow = 3,
                })
            end
        end
    end,
})
end

--- FUMAÇA EM FOGO (vai consumir muita memoria isso)
if btmt.fire_smoke then 	
minetest.register_abm({
    nodenames = {"group:fire"},
    interval = 3,
    chance = 1,
    catch_up = false,
    action = function(pos)
               for fsm = 1,5 do
                minetest.add_particle({
                    pos = {x=pos.x, y=pos.y-0.5, z=pos.z},
                    
                    velocity = {
                    x=math.random(-0.01,0.01),
                    y=math.random(0.5,0.9), 
                    z=math.random(-0.01,0.01)
                    },
                    
                    acceleration = {x=0, y=0, z=0},
                    expirationtime = 5,
                    size = math.random(3,5),
                    texture = "tnt_smoke.png",
                    glow = 3,
                })
            end
    end,
})
end

-- BOLHAS:
if btmt.breathing_underwater then --
local breathing_time = 0
function player_in_water(player)
    local pp = player:get_pos()
    local pd = player:get_look_dir()
    local np = minetest.get_node({x = pp.x, y = pp.y + 1.4, z = pp.z})
    local np2 = minetest.get_node({x = pp.x, y = pp.y + 1, z = pp.z})
    if np.name == "default:water_source" then
          minetest.add_particle({
            pos = {x=pp.x, y=pp.y + 1.5, z=pp.z},                                     
            velocity = {x=pd.x + math.random(-0.1,0.1),y= pd.y,z=pd.z + math.random(-0.1,0.1),},                   
            acceleration = {x=0, y= math.random(0.5,1), z=0},
            expirationtime = math.random(0.5,0.7),
            size = math.random(0.9,1.5),
            texture = "bubble.png",
            glow = 0})  
    end
end

minetest.register_globalstep(function()
 local current_time = minetest.get_us_time()
 if current_time - breathing_time >= 0.3 * (10^6)  then 
    breathing_time = current_time		 
   for _,player in ipairs(minetest.get_connected_players()) do
     player_in_water(player)
   end
 end
end)
end --
	
