-- Pedras
core.register_node("btmt:pebble", {
    description = "Pebble",
    inventory_image = "pebble.png",
    wield_image = "pebble.png",
    drawtype = "nodebox",
    tiles = {"default_stone.png"},
    paramtype = "light",
    paramtype2 = "facedir",
    groups = {cracky = 3},
    node_box = {
        type = "fixed",
        fixed = {
            {-0.2, -0.5, -0.2, 0.2, -0.35, 0.2}, 
            {-0.5, -0.5, 0.5, -0.2, -0.45, 0.2}, 
            {0.5, -0.5, 0.1, 0.3, -0.45, 0.3} 
        },
    },
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.2, -0.5, -0.2, 0.2, -0.35, 0.2}, 
            {-0.5, -0.5, 0.5, -0.2, -0.45, 0.2}, 
            {0.5, -0.5, 0.1, 0.3, -0.45, 0.3}
        },
    },
 
   drop = "btmt:pebble", 
})

core.register_node("btmt:pebble_snow", {
    description = "Pebble With Snow",
    inventory_image = "pebble_snow.png",
    wield_image = "pebble_snow.png",
    drawtype = "nodebox",
    tiles = {"default_snow.png","default_stone.png"},
    paramtype = "light",
    paramtype2 = "facedir",
    groups = {cracky = 3},
    node_box = {
        type = "fixed",
        fixed = {
            {-0.2, -0.5, -0.2, 0.2, -0.35, 0.2}, 
            {-0.5, -0.5, 0.5, -0.2, -0.45, 0.2}, 
            {0.5, -0.5, 0.1, 0.3, -0.45, 0.3} 
        },
    },
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.2, -0.5, -0.2, 0.2, -0.35, 0.2}, 
            {-0.5, -0.5, 0.5, -0.2, -0.45, 0.2}, 
            {0.5, -0.5, 0.1, 0.3, -0.45, 0.3}
        },
    },
 
   drop = "btmt:pebble_snow", 
})

core.register_node("btmt:pebble_moss", {
    description = "Pebble With Moss",
    inventory_image = "pebble_moss.png",
    wield_image = "pebble_moss.png",
    drawtype = "nodebox",
    tiles = {"default_moss.png","default_stone.png"},
    paramtype = "light",
    paramtype2 = "facedir",
    groups = {cracky = 3},
    node_box = {
        type = "fixed",
        fixed = {
            {-0.2, -0.5, -0.2, 0.2, -0.35, 0.2}, 
            {-0.5, -0.5, 0.5, -0.2, -0.45, 0.2}, 
            {0.5, -0.5, 0.1, 0.3, -0.45, 0.3} 
        },
    },
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.2, -0.5, -0.2, 0.2, -0.35, 0.2}, 
            {-0.5, -0.5, 0.5, -0.2, -0.45, 0.2}, 
            {0.5, -0.5, 0.1, 0.3, -0.45, 0.3}
        },
    },
 
   drop = "btmt:pebble_moss", 
})

core.register_decoration({
	name = "btmt:pebble_dec",
	deco_type = "simple",
	place_on = {
	"default:dirt_with_grass",
	"default:dry_dirt_with_dry_grass",
	"default:dirt_with_coniferous_litter",
	"default:dirt_with_rainforest_litter",
	"default:sand",
	"default:cobble",
	"default:mossycobble",
	"default:stone"
	},
	sidelen = 16,
	fill_ratio = 0.007,
	
	biomes = {
	"grassland",
	"deciduous_forest",
	"savanna",
	"rainforest",
	"coniferous_forest",
	"grassland_ocean",
	"coniferous_forest_ocean",
	"grassland_dunes",
	"coniferous_forest_dunes",
	"underground"
	},
	
	y_min = -200,
	y_max = 200,
	decoration = "btmt:pebble",
})

core.register_decoration({
	name = "btmt:pebble_w_snow_dec",
	deco_type = "simple",
	place_on = {"default:dirt_with_snow"},
	sidelen = 16,
	fill_ratio = 0.009,	
	biomes = {"taiga"},	
	y_min = 1,
	y_max = 200,
	decoration = "btmt:pebble_snow",
})

core.register_decoration({
	name = "btmt:pebble_w_moss_dec",
	deco_type = "simple",
	 place_on = {"default:dirt_with_grass","default:dirt_with_coniferous_litter"},
	sidelen = 16,
	fill_ratio = 0.009,	
	biomes = {"deciduous_forest","coniferous_forest"},	
	y_min = 1,
	y_max = 200,
	decoration = "btmt:pebble_moss",
})

--- ICICLES :
core.register_node("btmt:icicle", {
    description = "Icicle",
    drawtype = "plantlike",
    tiles = {"btmt_Icicle.png"},
    damage_per_second = 1,
    walkable = false,
    buildable_to = true,
    paramtype = "light",
    sunlight_propagates = true,
    groups = {cracky = 3, oddly_breakable_by_hand = 3},
    sounds = default.node_sound_glass_defaults(),
    drops = " ",
    selection_box = {
        type = "fixed",
        fixed = {-0.2,0.1,-0.2,0.2,0.5,0.2},
    },
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"default:pine_needles","default:cave_ice"},
    sidelen = 16,
    place_offset_y = 0,
    biomes = {"taiga","icesheet"},
    flags = "place_center_x,place_center_z,force_placement,all_ceilings",
    fill_ratio = 0.009,
    y_max = 2000,
    y_min = -35,
    decoration = "btmt:icicle",
})

--- STONES DECO BIOMES:	
core.register_decoration({ 
    name = "btmt:stones_decos_mossy",
    deco_type = "schematic",
    place_on = {"default:dirt_with_grass","default:dirt_with_coniferous_litter"},
    biomes = {"deciduous_forest","coniferous_forest"},
    sidelen = 16,
    fill_ratio = 0.001,
    y_max = 2000,
    y_min = -1,
    schematic = minetest.get_modpath("btmt") .. "/schematics/stones_deco_mossy_2.mts",
    place_offset_y = 1,
    flags = "place_center_x,place_center_z,all_floors",
    rotation = "random",
})

core.register_decoration({ 
    name = "btmt:stones_decos",
    deco_type = "schematic",
    place_on = { "default:dirt_with_snow", "default:dry_dirt_with_dry_grass"},
    biomes = {"savanna","taiga"},
    sidelen = 16,
    fill_ratio = 0.001,
    y_max = 2000,
    y_min = -1,
    schematic = minetest.get_modpath("btmt") .. "/schematics/stones_deco.mts",
    place_offset_y = 1,
    flags = "place_center_x,place_center_z,all_floors",
    rotation = "random",
})

--core.unregister_biome("icesheet_under")
